/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.temp;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import tv.soaryn.xycraft.machines.temp.IOrientationStrategy;
import tv.soaryn.xycraft.machines.temp.RelativeSide;

public enum BlockOrientation {
    DOWN_NORTH(90, 0, 0, 0),
    DOWN_WEST(90, 0, 270, 1),
    DOWN_SOUTH(90, 0, 180, 2),
    DOWN_EAST(90, 0, 90, 3),
    UP_NORTH(270, 0, 180, 0),
    UP_EAST(270, 0, 90, 1),
    UP_SOUTH(270, 0, 0, 2),
    UP_WEST(270, 0, 270, 3),
    NORTH_UP(0, 0, 0, 0),
    NORTH_WEST(0, 0, 270, 1),
    NORTH_DOWN(0, 0, 180, 2),
    NORTH_EAST(0, 0, 90, 3),
    SOUTH_UP(0, 180, 0, 0),
    SOUTH_EAST(0, 180, 90, 1),
    SOUTH_DOWN(0, 180, 180, 2),
    SOUTH_WEST(0, 180, 270, 3),
    WEST_UP(0, 270, 0, 0),
    WEST_SOUTH(0, 270, 270, 1),
    WEST_DOWN(0, 270, 180, 2),
    WEST_NORTH(0, 270, 90, 3),
    EAST_UP(0, 90, 0, 0),
    EAST_NORTH(0, 90, 270, 1),
    EAST_DOWN(0, 90, 180, 2),
    EAST_SOUTH(0, 90, 90, 3);

    private final int up;
    private final Direction[] rotatedSideTo;
    private final Direction[] rotatedSideFrom;

    private BlockOrientation(int angleX, int angleY, int angleZ, int up) {
        Quaternionf quaternion = new Quaternionf().rotateYXZ((float)(-angleY) * ((float)Math.PI / 180), (float)(-angleX) * ((float)Math.PI / 180), (float)(-angleZ) * ((float)Math.PI / 180));
        this.up = up;
        this.rotatedSideTo = new Direction[Direction.values().length];
        this.rotatedSideFrom = new Direction[Direction.values().length];
        for (Direction direction : Direction.values()) {
            Direction rotatedTo;
            Vector3f normal = direction.step();
            normal.rotate((Quaternionfc)quaternion);
            this.rotatedSideTo[direction.ordinal()] = rotatedTo = Direction.getNearest((float)normal.x(), (float)normal.y(), (float)normal.z());
            this.rotatedSideFrom[rotatedTo.ordinal()] = direction;
        }
    }

    public void setBlockState(BlockEntity be) {
        this.setBlockState(Objects.requireNonNull(be.getLevel(), "block entity's level can not be null when rotating"), be.getBlockPos());
    }

    public void setBlockState(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        IOrientationStrategy strategy = IOrientationStrategy.get(state);
        BlockState newState = strategy.setOrientation(state, this.getSide(RelativeSide.FRONT), this.getUp());
        if (newState != state) {
            level.invalidateCapabilities(pos);
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public Direction rotate(Direction facing) {
        return this.rotatedSideTo[facing.ordinal()];
    }

    public Direction resultingRotate(Direction facing) {
        return this.rotatedSideFrom[facing.ordinal()];
    }

    public int getUp() {
        return this.up;
    }

    public static BlockOrientation get(Direction facing) {
        return BlockOrientation.get(facing, 0);
    }

    public static BlockOrientation get(Direction front, Direction top) {
        int offset;
        for (int i = offset = front.ordinal() * 4; i < offset + 4; ++i) {
            BlockOrientation orientation = BlockOrientation.values()[i];
            if (orientation.getSide(RelativeSide.TOP) != top) continue;
            return orientation;
        }
        return BlockOrientation.values()[offset];
    }

    public static BlockOrientation get(Direction facing, int up) {
        return BlockOrientation.values()[facing.ordinal() * 4 + up];
    }

    public static BlockOrientation get(BlockEntity blockEntity) {
        BlockState blockState = blockEntity.getBlockState();
        return BlockOrientation.get(blockState);
    }

    public static BlockOrientation get(BlockState state) {
        IOrientationStrategy strategy = IOrientationStrategy.get(state);
        return BlockOrientation.get(strategy, state);
    }

    public static BlockOrientation get(IOrientationStrategy strategy, BlockState state) {
        Direction facing = strategy.getFacing(state);
        int spin = strategy.getSpin(state);
        return BlockOrientation.get(facing, spin);
    }

    public Direction getSide(RelativeSide side) {
        return this.rotate(side.toOriginal());
    }

    public RelativeSide getRelativeSide(Direction side) {
        return RelativeSide.fromOriginal(this.resultingRotate(side));
    }

    public BlockOrientation rotateClockwiseAround(Direction side) {
        return this.rotateClockwiseAround(side.getAxis(), side.getAxisDirection());
    }

    public BlockOrientation rotateClockwiseAround(Direction.Axis axis, Direction.AxisDirection direction) {
        Direction newUp;
        Direction newFacing;
        Direction facing = this.getSide(RelativeSide.FRONT);
        Direction up = this.getSide(RelativeSide.TOP);
        if (direction == Direction.AxisDirection.POSITIVE) {
            newFacing = facing.getClockWise(axis);
            newUp = up.getClockWise(axis);
        } else {
            newFacing = facing.getCounterClockWise(axis);
            newUp = up.getCounterClockWise(axis);
        }
        return BlockOrientation.get(newFacing, newUp);
    }
}

