/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.machines.content.blocks.collector.CollectorBlockEntity;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;

public class CollectorMenu
extends BaseMenu {
    public final CollectorBlockEntity BlockEntity;
    private final Level _level;

    public CollectorMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        this(id, inventory, inventory.player.level().getBlockEntity(data.readBlockPos()), (ItemContainer)new SimpleItemContainer(27));
    }

    public CollectorMenu(int id, Inventory inventory, BlockEntity entity, ItemContainer fullInventory) {
        super(MachinesMenus.Collector, id, inventory, null, 220, 192);
        this.BlockEntity = (CollectorBlockEntity)entity;
        this._level = inventory.player.level();
        ItemContainer inventoryInventory = fullInventory.slice(0, 9);
        ItemContainer bufferInventory = fullInventory.slice(9, 18);
        ItemContainer filterInventory = fullInventory.slice(18, 27);
        ItemContainer bufferContainer = ItemContainer.wrap((IItemHandler)bufferInventory.asHandler(HandlerIOBehavior.EXTRACT_ONLY));
        BaseMenu.Region playerRegion = this.createRegion();
        BaseMenu.Region inventoryRegion = this.createRegion();
        BaseMenu.Region bufferRegion = this.createRegion();
        BaseMenu.Region filterRegion = this.createRegion();
        playerRegion.addShiftTargets(new BaseMenu.RegionHandle[]{inventoryRegion});
        inventoryRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        bufferRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        playerRegion.addPlayerSlots(30, 108, inventory);
        int x = 18;
        int y = 16;
        filterRegion.addGhostSlots(x, y, 3, 3, filterInventory, 0, 1);
        bufferRegion.addSlots(x + 66, y, 3, 3, bufferContainer, 0);
        inventoryRegion.addSlots(x + 132, y, 3, 3, inventoryInventory, 0);
    }

    public boolean stillValid(@NotNull Player player) {
        return CollectorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this._level, (BlockPos)this.BlockEntity.getBlockPos()), (Player)player, (Block)MachinesContent.Block.Collector.block());
    }

    public void onMessage(int component, FriendlyByteBuf buf) {
    }
}

