/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.blender;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record BlenderRecipe(Either<SizedFluidIngredient, SizedIngredient> inputA, Optional<Either<SizedFluidIngredient, SizedIngredient>> inputB, Either<FluidStack, ItemStack> output, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, BlenderRecipe>,
IRecipeWithStage
{
    private static final MapCodec<BlenderRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObjectIngredient.fieldOf("ingredient_a").forGetter(BlenderRecipe::inputA), (App)CodecUtils.Codecs.ContentObjectIngredient.optionalFieldOf("ingredient_b").forGetter(BlenderRecipe::inputB), (App)CodecUtils.Codecs.ContentObject.fieldOf("output").forGetter(BlenderRecipe::output), (App)Codec.LONG.fieldOf("ticks").forGetter(BlenderRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(BlenderRecipe::requiredStage)).apply((Applicative)builder, BlenderRecipe::new));
    private static final BinarySerializer<BlenderRecipe> SerDes = BinarySerializer.ofType(BlenderRecipe::new, BlenderRecipe::inputA, (BinarySerializer)RecipeSerDes.InputObjectSerDes, BlenderRecipe::inputB, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)RecipeSerDes.InputObjectSerDes), BlenderRecipe::output, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, BlenderRecipe::ticks, (BinarySerializer)Serializer.LONG, BlenderRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<BlenderRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<BlenderRecipe> getContent() {
        return MachinesRecipeTypes.Blender;
    }

    public IOMode inputModeA() {
        return this.inputA.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode inputModeB() {
        return this.inputB.map(fluidStackItemStackEither -> fluidStackItemStackEither.left().isPresent() ? IOMode.Fluid : IOMode.Item).orElse(IOMode.Empty);
    }

    public IOMode outputMode() {
        return this.output.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return (Boolean)this.inputA.map(left -> left.test(input.getInputFluid(0)), right -> right.test(input.getInputItem(0))) != false && this.inputB.map(either -> (Boolean)either.map(left -> left.test(input.getInputFluid(1)), right -> right.test(input.getInputItem(1)))).orElse(true) != false;
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Input
    extends IRecipeContainer {
        public ItemStack getInputItem(int var1);

        public FluidStack getInputFluid(int var1);
    }
}

