/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.buffer;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;

public class BufferBlockClient {
    private static final IClientBlockExtensions ParticleHandler = new IClientBlockExtensions(){

        public boolean addDestroyEffects(BlockState state, @NotNull Level Level2, @NotNull BlockPos pos, @NotNull ParticleEngine manager) {
            state.getShape((BlockGetter)Level2, pos).forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double xDif = Math.min(1.0, maxX - minX);
                double yDif = Math.min(1.0, maxY - minY);
                double zDif = Math.min(1.0, maxZ - minZ);
                int xCount = Mth.ceil((double)(xDif / 0.25));
                int yCount = Mth.ceil((double)(yDif / 0.25));
                int zCount = Mth.ceil((double)(zDif / 0.25));
                if (xCount > 0 && yCount > 0 && zCount > 0) {
                    for (int x = 0; x < xCount; ++x) {
                        for (int y = 0; y < yCount; ++y) {
                            for (int z = 0; z < zCount; ++z) {
                                double d4 = ((double)x + 0.5) / (double)xCount;
                                double d5 = ((double)y + 0.5) / (double)yCount;
                                double d6 = ((double)z + 0.5) / (double)zCount;
                                double d7 = d4 * xDif + minX;
                                double d8 = d5 * yDif + minY;
                                double d9 = d6 * zDif + minZ;
                                manager.add((Particle)new TerrainParticle((ClientLevel)Level2, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).updateSprite(state, pos));
                            }
                        }
                    }
                }
            });
            return true;
        }
    };

    public static IClientBlockExtensions particles() {
        return ParticleHandler;
    }
}

