/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level.xynergy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jgrapht.Graphs;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraph;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraphNode;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public record XynergyNet(Long2ObjectOpenHashMap<UUID> PosToId, Object2ObjectOpenHashMap<UUID, XynergyGraph> IdToGraph, Long2ObjectOpenHashMap<LongArraySet> ChunkToPos) {
    public static final Codec<XynergyNet> CODEC = RecordCodecBuilder.create((T builder) -> builder.group((App)CodecUtils.tupleOf(Codec.LONG, UUIDUtil.CODEC, Long2ObjectOpenHashMap::new).fieldOf("pos_to_id").forGetter(XynergyNet::PosToId), (App)CodecUtils.tupleOf(UUIDUtil.CODEC, XynergyGraph.CODEC, Object2ObjectOpenHashMap::new).fieldOf("graphs").forGetter(XynergyNet::IdToGraph), (App)CodecUtils.tupleOf(Codec.LONG, NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).xmap(LongArraySet::new, LongArraySet::new), Long2ObjectOpenHashMap::new).fieldOf("graphs").forGetter(XynergyNet::ChunkToPos)).apply((Applicative)builder, XynergyNet::create));
    public static final AttachmentType.Builder<XynergyNet> BUILDER = AttachmentUtils.createBuilder(XynergyNet::create, CODEC, XynergyNet::setAttachmentHolder);
    private static final BlockPos.MutableBlockPos PositionMapper = new BlockPos.MutableBlockPos();

    public static XynergyNet create(IAttachmentHolder holder) {
        XynergyNet net = XynergyNet.create((Long2ObjectOpenHashMap<UUID>)new Long2ObjectOpenHashMap(), (Object2ObjectOpenHashMap<UUID, XynergyGraph>)new Object2ObjectOpenHashMap(), (Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap());
        net.setAttachmentHolder(holder);
        return net;
    }

    public static XynergyNet create(Long2ObjectOpenHashMap<UUID> posToId, Object2ObjectOpenHashMap<UUID, XynergyGraph> graphs, Long2ObjectOpenHashMap<LongArraySet> chunkToPos) {
        return new XynergyNet((Long2ObjectOpenHashMap<UUID>)new Long2ObjectOpenHashMap(posToId), (Object2ObjectOpenHashMap<UUID, XynergyGraph>)new Object2ObjectOpenHashMap(graphs), (Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(chunkToPos));
    }

    public void setAttachmentHolder(IAttachmentHolder holder) {
        IAttachmentHolder iAttachmentHolder = holder;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerLevel.class}, (Object)iAttachmentHolder, n)) {
            case 0: {
                ServerLevel serverLevel = (ServerLevel)iAttachmentHolder;
                for (XynergyGraph graph : this.IdToGraph.values()) {
                    graph.load(serverLevel);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Tried to add XynergyNet on a " + holder.getClass().getSimpleName());
            }
        }
    }

    public XynergyGraph getGraph(BlockPos pos) {
        return this.getGraph(pos.asLong());
    }

    public XynergyGraph getGraph(long posId) {
        UUID id = (UUID)this.PosToId.get(posId);
        if (id == null) {
            return null;
        }
        return (XynergyGraph)this.IdToGraph.get((Object)id);
    }

    public void addToChunk(long value) {
        long chunkPosId = ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value)), (int)SectionPos.blockToSectionCoord((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value))));
        ((LongArraySet)this.ChunkToPos.computeIfAbsent(chunkPosId, o -> new LongArraySet())).add(value);
    }

    public void removeFromChunk(long value) {
        long chunkPosId = ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value)), (int)SectionPos.blockToSectionCoord((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value))));
        LongArraySet chunks = (LongArraySet)this.ChunkToPos.get(chunkPosId);
        if (chunks == null) {
            return;
        }
        chunks.remove(chunkPosId);
        if (chunks.isEmpty()) {
            this.ChunkToPos.remove(chunkPosId);
        }
    }

    public void connectNode(ServerLevel level, Player player, long from, long to) {
        XynergyGraph graphA = this.getGraph(from);
        XynergyGraph graphB = this.getGraph(to);
        if (graphA == null && graphB == null) {
            graphA = new XynergyGraph(level);
            graphA.addNode(level, from);
            graphA.addNode(level, to);
            graphA.addEdge(from, to);
            return;
        }
        if (graphA != null && graphB == null) {
            graphA.addNode(level, to);
            graphA.addEdge(from, to);
            this.PosToId.put(to, (Object)graphA.Id);
            this.addToChunk(to);
        } else if (graphA == null) {
            graphB.addNode(level, from);
            graphB.addEdge(from, to);
            this.addToChunk(from);
        } else {
            XynergyGraph mainGraph = graphA;
            XynergyGraph altGraph = graphB;
            if (mainGraph == altGraph) {
                mainGraph.addEdge(from, to);
                return;
            }
            if (graphA.Graph.vertexSet().size() < graphB.Graph.vertexSet().size()) {
                mainGraph = graphB;
                altGraph = graphA;
            }
            Graphs.addGraph(mainGraph.Graph, altGraph.Graph);
            mainGraph.addEdge(from, to);
            mainGraph.Power.Supply += altGraph.Power.Supply;
            mainGraph.Power.Demand += altGraph.Power.Demand;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (Long2ObjectMap.Entry entry : altGraph.NodeCache.long2ObjectEntrySet()) {
                long posId = entry.getLongKey();
                pos.set(posId);
                XynergyGraphNode oldNode = (XynergyGraphNode)entry.getValue();
                XynergyGraphNode newNode = new XynergyGraphNode(oldNode.Value, oldNode.Type);
                mainGraph.NodeCache.put(posId, (Object)newNode);
                newNode.getCachedCapability(level, posId, (BlockPos)pos, mainGraph);
                this.PosToId.put(posId, (Object)mainGraph.Id);
            }
            altGraph.Graph.removeAllVertices(Set.copyOf(altGraph.Graph.vertexSet()));
        }
    }

    public void disconnectNode(Player player, long from, long to) {
        XynergyGraph graphA = this.getGraph(from);
        XynergyGraph graphB = this.getGraph(to);
        if (graphA == null || graphA != graphB) {
            return;
        }
        graphA.removeEdge(from, to);
    }
}

