/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item2;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;

public record VanillaToItemContainerAdapter(Container container) implements IResourceContainer<ItemResource>
{
    @Override
    @NotNull
    public MutableResourceStack<ItemResource> defaultResource() {
        return MutableResourceStack.Empty.ITEM;
    }

    @Override
    public int size() {
        return this.container.getContainerSize();
    }

    @Override
    @NotNull
    public MutableResourceStack<ItemResource> get(int index) {
        ItemStack stack = this.container.getItem(index);
        return MutableResourceStack.of(ItemResource.of(stack), stack.getCount());
    }

    @Override
    public void set(int index, @Nonnull @NotNull MutableResourceStack<ItemResource> stack) {
        this.container.setItem(index, stack.resource().toStack(stack.amount()));
    }

    @Override
    public boolean isValid(int index, @NotNull ItemResource resource) {
        return this.container.canPlaceItem(index, resource.toStack());
    }

    @Override
    public int getCapacity(int index, @NotNull ItemResource resource) {
        return Math.min(this.container.getMaxStackSize(resource.toStack()), resource.getMaxStackSize());
    }

    @Override
    public int getCapacity(int index) {
        return this.container.getMaxStackSize();
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty();
    }
}

