/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.PlayerStatus;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PlayerStatusManager {
    public HashMap<UUID, PlayerStatus> lookupPlayerToStatus = new HashMap();
    protected boolean singleplayerTesting = false;

    public void tickPlayer(Player player) {
        this.singleplayerTesting = false;
        if (player.level().isClientSide()) {
            this.tickPlayerClient(player);
        }
    }

    public void tickPlayerClient(Player player) {
    }

    public PlayerStatus getStatus(Player player) {
        return this.getStatus(player.getUUID());
    }

    public PlayerStatus getStatus(UUID uuid) {
        return this.getStatus(uuid, false);
    }

    public PlayerStatus getStatus(UUID uuid, boolean local) {
        if (local) {
            return this.getStatusLocal();
        }
        PlayerStatus status = this.lookupPlayerToStatus.get(uuid);
        if (status == null) {
            status = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE, uuid);
            this.lookupPlayerToStatus.put(uuid, status);
        }
        return status;
    }

    public PlayerStatus getStatusLocal() {
        return null;
    }

    public void setMouse(UUID uuid, float x, float y, boolean pressed) {
        PlayerStatus status = this.getStatus(uuid);
        status.setScreenPosPercentX(x);
        status.setScreenPosPercentY(y);
        status.setPressing(pressed);
    }

    public void playerLoggedIn(Player player) {
    }

    public Vec3 getBodyAngle(Player player) {
        return this.calculateViewVector(player.getXRot(), player.yBodyRot);
    }

    public Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

