/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.jankson.impl;

import java.util.Locale;
import me.drex.villagerconfig.shadow.jankson.Jankson;
import me.drex.villagerconfig.shadow.jankson.JsonElement;
import me.drex.villagerconfig.shadow.jankson.JsonNull;
import me.drex.villagerconfig.shadow.jankson.JsonPrimitive;
import me.drex.villagerconfig.shadow.jankson.api.SyntaxError;
import me.drex.villagerconfig.shadow.jankson.impl.AnnotatedElement;
import me.drex.villagerconfig.shadow.jankson.impl.ArrayParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.CommentParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.NumberParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.ObjectParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.ParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.StringParserContext;
import me.drex.villagerconfig.shadow.jankson.impl.TokenParserContext;

public class ElementParserContext
implements ParserContext<AnnotatedElement> {
    String comment = null;
    AnnotatedElement result = null;
    boolean childActive = false;

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        if (Character.isWhitespace(codePoint)) {
            return true;
        }
        switch (codePoint) {
            case 35: 
            case 47: {
                loader.push(new CommentParserContext(codePoint), it -> {
                    this.comment = it;
                });
                return true;
            }
            case 34: 
            case 39: {
                loader.push(new StringParserContext(codePoint), this::setResult);
                this.childActive = true;
                return true;
            }
            case 123: {
                loader.push(new ObjectParserContext(), this::setResult);
                this.childActive = true;
                return false;
            }
            case 91: {
                loader.push(new ArrayParserContext(), this::setResult);
                this.childActive = true;
                return true;
            }
            case 125: {
                loader.throwDelayed(new SyntaxError("Found '" + (char)codePoint + "' while parsing an element - this shouldn't happen!"));
                return false;
            }
            case 93: {
                this.result = new AnnotatedElement(null, this.comment);
                return false;
            }
        }
        if (Character.isDigit(codePoint) || codePoint == 45 || codePoint == 43 || codePoint == 46) {
            loader.push(new NumberParserContext(codePoint), this::setResult);
            this.childActive = true;
            return true;
        }
        loader.push(new TokenParserContext(codePoint), it -> {
            String token;
            switch (token = it.asString().toLowerCase(Locale.ROOT)) {
                case "null": {
                    this.setResult(JsonNull.INSTANCE);
                    break;
                }
                case "true": {
                    this.setResult(JsonPrimitive.TRUE);
                    break;
                }
                case "false": {
                    this.setResult(JsonPrimitive.FALSE);
                    break;
                }
                case "infinity": 
                case "+infinity": {
                    this.setResult(new JsonPrimitive(Double.POSITIVE_INFINITY));
                    break;
                }
                case "-infinity": {
                    this.setResult(new JsonPrimitive(Double.NEGATIVE_INFINITY));
                    break;
                }
                case "nan": {
                    this.setResult(new JsonPrimitive(Double.NaN));
                    break;
                }
                default: {
                    this.setResult((JsonElement)it);
                }
            }
        });
        this.childActive = true;
        return true;
    }

    public void setResult(JsonElement elem) {
        this.result = new AnnotatedElement(elem, this.comment);
    }

    @Override
    public void eof() throws SyntaxError {
        if (!this.childActive) {
            throw new SyntaxError("Unexpected end-of-file while looking for a json element!");
        }
    }

    @Override
    public boolean isComplete() {
        return this.result != null;
    }

    @Override
    public AnnotatedElement getResult() throws SyntaxError {
        return this.result;
    }
}

