/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.data;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.drex.villagerconfig.common.data.BehaviorTrade;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class TradeGroup {
    public static final Codec<TradeGroup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("num_to_select").forGetter(tradeGroup -> tradeGroup.numToSelect), (App)BehaviorTrade.CODEC.listOf().fieldOf("trades").forGetter(tradeGroup -> tradeGroup.trades)).apply((Applicative)instance, TradeGroup::new));
    final NumberProvider numToSelect;
    final List<BehaviorTrade> trades;

    public TradeGroup(NumberProvider numToSelect, List<BehaviorTrade> trades) {
        this.numToSelect = numToSelect;
        this.trades = trades;
    }

    public List<BehaviorTrade> getTrades(AbstractVillager villager) {
        LootParams lootParams = new LootParams.Builder((ServerLevel)villager.level()).withParameter(LootContextParams.ORIGIN, (Object)villager.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)villager).withParameter(VCLootContextParams.NUMBER_REFERENCE, Collections.emptyMap()).create(VCLootContextParams.VILLAGER_LOOT_CONTEXT);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        List<BehaviorTrade> applicableTrades = this.trades.stream().filter(behaviorTrade -> behaviorTrade.compositeCondition.test(lootContext)).toList();
        HashSet set = Sets.newHashSet();
        int count = this.numToSelect.getInt(lootContext);
        if (applicableTrades.size() > count) {
            while (set.size() < count) {
                set.add(lootContext.getRandom().nextInt(applicableTrades.size()));
            }
        } else {
            return applicableTrades;
        }
        BehaviorTrade[] factories = new BehaviorTrade[set.size()];
        int index = 0;
        for (Integer integer : set) {
            factories[index] = applicableTrades.get(integer);
            ++index;
        }
        return List.of(factories);
    }
}

