/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFMapDecorations;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.chunkgenerators.AbsoluteDifferenceFunction;
import twilightforest.world.components.chunkgenerators.FocusedDensityFunction;
import twilightforest.world.components.chunkgenerators.HollowHillFunction;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawningStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class LabyrinthStructure
extends ControlledSpawningStructure
implements ConfigurableSpawns,
CustomDensitySource {
    public static final MapCodec<LabyrinthStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> LabyrinthStructure.controlledSpawningCodec(instance).apply((Applicative)instance, LabyrinthStructure::new));

    public LabyrinthStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, centerInChunk, structureIcon, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new MazeRuinsComponent(0, x + 5, y, z + 5);
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.LABYRINTH.get();
    }

    public static LabyrinthStructure buildLabyrinthConfig(BootstrapContext<Structure> context) {
        return new LabyrinthStructure(ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MINOTAUR.get(), 20, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.CAVE_SPIDER, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MAZE_SLIME.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 1, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PINCH_BEETLE.get(), 10, 1, 1)), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_lich"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("labyrinth", 5), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(3.0f, true, false, false), true, Optional.of(TFMapDecorations.LABYRINTH), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_LABYRINTH_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY));
    }

    @Override
    public DensityFunction getStructureTerraformer(ChunkPos chunkSliceAt, StructureStart structurePieceSource) {
        float radius = 35.0f;
        BoundingBox structureBox = structurePieceSource.getBoundingBox();
        BlockPos hillCenter = structureBox.getCenter();
        int yCeilingFocus = hillCenter.getY();
        DensityFunction hillMound = new HollowHillFunction(hillCenter.getX() + 1, hillCenter.getY() + 7, (float)hillCenter.getZ() + 2.0f, 35.0f, 0.8f).clamp(0.0, 2.0);
        DensityFunction ceilingCapped = DensityFunctions.yClampedGradient((int)5, (int)6, (double)-1.0, (double)1.0);
        BlockPos pos = hillCenter.offset(1, 0, 1);
        DensityFunction innerFloor = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-4, (int)3, (double)26.0, (double)-1.0), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-1.0), (DensityFunction)new AbsoluteDifferenceFunction.Max(32.0, (float)pos.getX() + 0.5f, (float)pos.getZ() + 0.5f)));
        DensityFunction entrances = DensityFunctions.max((DensityFunction)ceilingCapped, (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-2.0), (DensityFunction)new AbsoluteDifferenceFunction.Min(32.0, (float)pos.getX() + 0.5f, (float)pos.getZ() + 0.5f)));
        DensityFunction interior = DensityFunctions.max((DensityFunction)entrances, (DensityFunction)innerFloor).clamp(0.0, 1.0);
        FocusedDensityFunction interiorMask = FocusedDensityFunction.fromPos(hillCenter.atY(yCeilingFocus), 24.5f, 35.0f, 0.0f);
        DensityFunction interiorMasked = DensityFunctions.lerp((DensityFunction)interiorMask.clamp(0.0, 1.0), (DensityFunction)DensityFunctions.zero(), (DensityFunction)interior);
        DensityFunction hollowHill = DensityFunctions.min((DensityFunction)hillMound, (DensityFunction)interiorMasked);
        return hollowHill;
    }
}

