/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.structures.lichtowerrevamp.StructureTemplateDefinition;
import twilightforest.world.components.structures.util.CodecResourceReloadListener;

public class StructureTemplateDefinitions
extends CodecResourceReloadListener<StructureTemplateDefinition> {
    public static final StructureTemplateDefinitions INSTANCE = new StructureTemplateDefinitions();
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> rawTemplatePools = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    private final Map<ResourceLocation, SimpleWeightedRandomList<ResourceLocation>> templatePools = new HashMap<ResourceLocation, SimpleWeightedRandomList<ResourceLocation>>();
    public static final String DIRECTORY = "twilight/template_definition";

    private StructureTemplateDefinitions() {
        super(DIRECTORY, StructureTemplateDefinition.CODEC);
    }

    @Override
    protected void forLocation(ResourceManager manager, ResourceLocation templateName, StructureTemplateDefinition templateDefinition) {
        for (Map.Entry<ResourceLocation, Integer> poolToRegisterWeight : templateDefinition.poolWeights().entrySet()) {
            ResourceLocation templatePoolId = poolToRegisterWeight.getKey();
            Integer templateWeight = poolToRegisterWeight.getValue();
            Map pool = this.rawTemplatePools.computeIfAbsent(templatePoolId, k -> new HashMap());
            pool.put(templateName, templateWeight);
        }
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        this.rawTemplatePools.clear();
        this.templatePools.clear();
        super.apply(map, manager, profiler);
        for (Map.Entry<ResourceLocation, Map<ResourceLocation, Integer>> rawTemplatePool : this.rawTemplatePools.entrySet()) {
            SimpleWeightedRandomList.Builder poolBuilder = SimpleWeightedRandomList.builder();
            List sortedTemplateWeights = rawTemplatePool.getValue().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
            for (Map.Entry templateIdWeight : sortedTemplateWeights) {
                poolBuilder.add((Object)((ResourceLocation)templateIdWeight.getKey()), ((Integer)templateIdWeight.getValue()).intValue());
            }
            ResourceLocation templatePoolId = rawTemplatePool.getKey();
            this.templatePools.put(templatePoolId, (SimpleWeightedRandomList<ResourceLocation>)poolBuilder.build());
        }
        this.rawTemplatePools.clear();
    }

    @Nullable
    private ResourceLocation rollTemplatePool(RandomSource random, ResourceLocation templatePoolId) {
        SimpleWeightedRandomList<ResourceLocation> templatePool = this.templatePools.get(templatePoolId);
        return templatePool == null ? null : (ResourceLocation)templatePool.getRandomValue(random).orElse(null);
    }

    private Iterable<ResourceLocation> shuffledTemplatePool(RandomSource random, ResourceLocation templatePoolId) {
        SimpleWeightedRandomList<ResourceLocation> templatePool = this.templatePools.get(templatePoolId);
        if (templatePool == null) {
            return List.of();
        }
        HashMap<ResourceLocation, Double> reservoirSampled = new HashMap<ResourceLocation, Double>();
        for (WeightedEntry.Wrapper entry : templatePool.unwrap()) {
            double rand = random.nextDouble();
            reservoirSampled.put((ResourceLocation)entry.data(), -Math.log(rand) / (double)entry.getWeight().asInt());
        }
        return reservoirSampled.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Nullable
    public static ResourceLocation getRandomTemplate(RandomSource random, ResourceLocation poolId) {
        return INSTANCE.rollTemplatePool(random, poolId);
    }

    public static Iterable<ResourceLocation> getShuffledSequence(RandomSource random, ResourceLocation poolId) {
        return INSTANCE.shuffledTemplatePool(random, poolId);
    }
}

