/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructureProcessors;

public class SpawnerProcessor
extends StructureProcessor {
    public static final MapCodec<SpawnerProcessor> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.SHORT.optionalFieldOf("range").forGetter(SpawnerProcessor::serializeRange), (App)Codec.FLOAT.optionalFieldOf("start_delay_factor").forGetter(SpawnerProcessor::getDelayFactor), (App)Codec.FLOAT.optionalFieldOf("entity_width_max").forGetter(SpawnerProcessor::getEntityWidthMax), (App)SpawnData.LIST_CODEC.fieldOf("entities").forGetter(SpawnerProcessor::getPossibleEntities)).apply((Applicative)inst, SpawnerProcessor::new));
    private final Optional<Short> range;
    private final Optional<Float> startDelayFactor;
    private final Optional<Float> entityWidthMax;
    private final SimpleWeightedRandomList<SpawnData> entities;

    public static SpawnerProcessor compile(int range, Object2IntMap<EntityType<?>> weightMap) {
        return SpawnerProcessor.compile(range, 0.0f, weightMap);
    }

    public static SpawnerProcessor compile(int range, float maxWidth, Object2IntMap<EntityType<?>> weightMap) {
        SimpleWeightedRandomList.Builder entities = SimpleWeightedRandomList.builder();
        for (Map.Entry entry : weightMap.entrySet()) {
            CompoundTag entityInfo = new CompoundTag();
            entityInfo.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)entry.getKey())).toString());
            entities.add((Object)new SpawnData(entityInfo, Optional.of(new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7)), new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15)))), Optional.empty()), ((Integer)entry.getValue()).intValue());
        }
        return new SpawnerProcessor(range <= 0 ? Optional.empty() : Optional.of((short)range), Optional.of(Float.valueOf(0.25f)), maxWidth <= 0.0f ? Optional.empty() : Optional.of(Float.valueOf(maxWidth)), (SimpleWeightedRandomList<SpawnData>)entities.build());
    }

    public SpawnerProcessor(Optional<Short> range, Optional<Float> startDelayFactor, Optional<Float> entityWidthMax, SimpleWeightedRandomList<SpawnData> entities) {
        this.range = range;
        this.startDelayFactor = startDelayFactor;
        this.entities = entities;
        this.entityWidthMax = entityWidthMax.isEmpty() ? Optional.empty() : (entityWidthMax.get().floatValue() <= 0.0f ? Optional.empty() : entityWidthMax);
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos offset, BlockPos piecePos, StructureTemplate.StructureBlockInfo originalInfo, StructureTemplate.StructureBlockInfo modifiedInfo, StructurePlaceSettings placeSettings, @Nullable StructureTemplate template) {
        CompoundTag nbtInfo = modifiedInfo.nbt();
        if (nbtInfo != null && (modifiedInfo.state().is(Blocks.SPAWNER) || modifiedInfo.state().is(TFBlocks.SINISTER_SPAWNER))) {
            Optional randomSpawn;
            if (this.range.isPresent()) {
                nbtInfo.putShort("SpawnRange", this.range.get().shortValue());
            }
            if (this.startDelayFactor.isPresent()) {
                nbtInfo.putShort("Delay", (short)Math.round((float)nbtInfo.getShort("MinSpawnDelay") * this.startDelayFactor.get().floatValue()));
            }
            if ((!nbtInfo.contains("SpawnData") || nbtInfo.getList("SpawnData", 10).isEmpty()) && (randomSpawn = this.entities.getRandomValue(placeSettings.getRandom(modifiedInfo.pos()))).isPresent()) {
                SpawnData spawn = (SpawnData)randomSpawn.get();
                Tag entitySpawnData = (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)spawn).getOrThrow(s -> new IllegalStateException("Invalid SpawnData in processing: " + s));
                if (this.entityWidthMax.isPresent() && entitySpawnData instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)entitySpawnData;
                    Optional type = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)spawn.entityToSpawn().getString("id")));
                    float newScale = this.rescaleToFitWidth(type.map(EntityType::getWidth).orElse(Float.valueOf(0.0f)).floatValue());
                    if (Float.isFinite(newScale) && newScale != 1.0f) {
                        CompoundTag entityCompound = compoundTag.getCompound("entity");
                        ListTag attributes = entityCompound.getList("attributes", 10);
                        CompoundTag scale = new CompoundTag();
                        scale.putString("id", "generic.scale");
                        scale.putFloat("base", newScale);
                        attributes.add((Object)scale);
                        entityCompound.put("attributes", (Tag)attributes);
                        compoundTag.put("entity", (Tag)entityCompound);
                    }
                }
                nbtInfo.put("SpawnData", entitySpawnData);
            }
        }
        return modifiedInfo;
    }

    public float rescaleToFitWidth(float entityWidth) {
        if (this.entityWidthMax.isEmpty() || entityWidth == 0.0f) {
            return 1.0f;
        }
        float maxWidth = this.entityWidthMax.get().floatValue();
        return entityWidth < maxWidth ? 1.0f : maxWidth / entityWidth;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TFStructureProcessors.SPAWNER_PROCESSOR.value();
    }

    private Optional<Short> serializeRange() {
        return this.range;
    }

    private Optional<Float> getDelayFactor() {
        return this.startDelayFactor;
    }

    private Optional<Float> getEntityWidthMax() {
        return this.entityWidthMax;
    }

    private SimpleWeightedRandomList<SpawnData> getPossibleEntities() {
        return this.entities;
    }
}

