/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.MasonJarBlockEntity;

public record SetMasonJarItemPacket(BlockPos pos, boolean empty, ItemStack stack, int rotation) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetMasonJarItemPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("set_mason_jar_item"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetMasonJarItemPacket> STREAM_CODEC = CustomPacketPayload.codec(SetMasonJarItemPacket::write, SetMasonJarItemPacket::read);

    public SetMasonJarItemPacket(BlockPos pos, ItemStack stack, int rotation) {
        this(pos, stack.isEmpty(), stack, rotation);
    }

    public static SetMasonJarItemPacket read(RegistryFriendlyByteBuf buf) {
        boolean empty;
        int rotation = buf.readInt();
        BlockPos pos = buf.readBlockPos();
        return new SetMasonJarItemPacket(pos, empty, (empty = buf.readBoolean()) ? ItemStack.EMPTY : (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), rotation);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.rotation());
        buf.writeBlockPos(this.pos());
        buf.writeBoolean(this.empty());
        if (!this.empty()) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.stack());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final SetMasonJarItemPacket packet, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientLevel level;
                    Level level2 = ctx.player().level();
                    if (level2 instanceof ClientLevel && (level2 = (level = (ClientLevel)level2).getBlockEntity(packet.pos())) instanceof MasonJarBlockEntity) {
                        MasonJarBlockEntity blockEntity = (MasonJarBlockEntity)level2;
                        blockEntity.getItemHandler().setItem(packet.stack());
                        blockEntity.setItemRotation(packet.rotation());
                        blockEntity.setChanged();
                    }
                }
            });
        }
    }
}

