/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.util.TFItemStackUtils;

public class MoonwormQueenItem
extends Item {
    public static final int FIRING_TIME = 12;

    public MoonwormQueenItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() == this.getMaxDamage(stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        BlockPlaceContext blockItemUseContext = new BlockPlaceContext(context);
        if (!state.canBeReplaced()) {
            pos = pos.relative(context.getClickedFace());
        }
        if (player != null) {
            ItemStack itemstack = player.getItemInHand(context.getHand());
            if (itemstack.getDamageValue() < itemstack.getMaxDamage() && player.mayUseItemAt(pos, context.getClickedFace(), itemstack) && level.isUnobstructed(((Block)TFBlocks.MOONWORM.get()).defaultBlockState(), pos, CollisionContext.empty())) {
                if (this.tryPlace(blockItemUseContext).shouldSwing()) {
                    SoundType soundtype = level.getBlockState(pos).getBlock().getSoundType(level.getBlockState(pos), (LevelReader)level, pos, (Entity)player);
                    level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    player.stopUsingItem();
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int useRemaining) {
        int useTime = this.getUseDuration(stack, living) - useRemaining;
        if (!level.isClientSide() && useTime > 12 && stack.getDamageValue() + 1 < stack.getMaxDamage() && level.addFreshEntity((Entity)new MoonwormShot((EntityType<? extends MoonwormShot>)((EntityType)TFEntities.MOONWORM_SHOT.get()), level, living))) {
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.getAbilities().instabuild) {
                    TFItemStackUtils.hurtButDontBreak(stack, 2, (ServerLevel)level, (LivingEntity)player);
                }
            }
            level.playSound(null, living.getX(), living.getY(), living.getZ(), (SoundEvent)TFSounds.MOONWORM_SQUISH.get(), living instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.getBlockItemUseContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.getClickedPos();
        Level level = blockitemusecontext.getLevel();
        Player playerentity = blockitemusecontext.getPlayer();
        ItemStack itemstack = blockitemusecontext.getItemInHand();
        BlockState blockstate1 = level.getBlockState(blockpos);
        Block block = blockstate1.getBlock();
        if (block == blockstate.getBlock()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, level, playerentity, itemstack);
            block.setPlacedBy(level, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
        level.playSound(playerentity, blockpos, this.getPlaceSound(blockstate1, level, blockpos, Objects.requireNonNull(context.getPlayer())), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!playerentity.getAbilities().instabuild) {
                TFItemStackUtils.hurtButDontBreak(itemstack, 1, server, (LivingEntity)playerentity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState state, Level level, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)level, pos, (Entity)entity).getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext getBlockItemUseContext(BlockPlaceContext context) {
        return context;
    }

    protected boolean onBlockPlaced(BlockPos pos, Level level, @Nullable Player player, ItemStack stack) {
        return BlockItem.updateCustomBlockEntityTag((Level)level, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = ((Block)TFBlocks.MOONWORM.get()).getStateForPlacement(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        CollisionContext collision = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collision);
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockItemStateProperties blockitemstateproperties = (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (blockitemstateproperties.isEmpty()) {
            return state;
        }
        BlockState blockstate = blockitemstateproperties.apply(state);
        if (blockstate != state) {
            level.setBlock(pos, blockstate, 2);
        }
        return blockstate;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }
}

