/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class IceBombItem
extends Item
implements ProjectileItem {
    public IceBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.playSound((SoundEvent)TFSounds.ICE_BOMB_FIRED.get(), 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide()) {
            player.getItemInHand(hand).consume(1, (LivingEntity)player);
            IceBomb ice = new IceBomb((EntityType<? extends IceBomb>)((EntityType)TFEntities.THROWN_ICE.get()), level, (LivingEntity)player);
            ice.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -5.0f, 1.25f, 1.0f);
            level.addFreshEntity((Entity)ice);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public Projectile asProjectile(Level level, Position position, ItemStack stack, Direction direction) {
        return new IceBomb(level, position);
    }
}

