/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.LichRenderer;
import twilightforest.entity.boss.Lich;

public class LichModel<T extends Lich>
extends HumanoidModel<T>
implements TrophyBlockModel {
    private boolean shadowClone;
    private final ModelPart collar;
    private final ModelPart cloak;

    public LichModel(ModelPart root) {
        super(root);
        this.collar = root.getChild("collar");
        this.cloak = root.getChild("cloak");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -12.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("collar", CubeListBuilder.create().texOffs(32, 16).addBox(-6.0f, -2.0f, -4.0f, 12.0f, 12.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.0f, (float)2.164208f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(0, 44).addBox(-6.0f, 2.0f, 0.0f, 12.0f, 19.0f, 1.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)2.5f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(8, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-5.0f, (float)-2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        if (!this.shadowClone) {
            super.renderToBuffer(stack, builder, light, overlay, color);
        } else {
            super.renderToBuffer(stack, builder, light, overlay, FastColor.ARGB32.color((int)((int)((float)FastColor.ARGB32.alpha((int)color) * 0.5f)), (int)((int)((float)FastColor.ARGB32.red((int)color) * 0.333f)), (int)((int)((float)FastColor.ARGB32.green((int)color) * 0.333f)), (int)((int)((float)FastColor.ARGB32.blue((int)color) * 0.333f))));
        }
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.shadowClone) {
            return super.bodyParts();
        }
        return Iterables.concat(Arrays.asList(this.cloak, this.collar), (Iterable)super.bodyParts());
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        if (entity.isDeadOrDying() && ((Lich)entity).deathTime < 115) {
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            limbSwingAmount = ((Lich)entity).walkAnimation.speed(partialTicks);
            limbSwing = ((Lich)entity).walkAnimation.position(partialTicks);
            if ((limbSwingAmount *= 1.5f) > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        } else {
            limbSwingAmount *= 0.75f;
        }
        this.shadowClone = ((Lich)entity).isShadowClone();
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (((Lich)entity).getPhase() != 3) {
            float ogSin = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float otherSin = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            if (((Lich)entity).tickCount > 0 && !entity.isDeadOrDying()) {
                this.leftArm.zRot = 0.5f;
                this.leftArm.yRot = 0.1f - ogSin * 0.6f;
                this.leftArm.xRot = -3.141593f;
                this.leftArm.xRot -= ogSin * 1.2f - otherSin * 0.4f;
                this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.26f)) * 0.15f + 0.05f;
                this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.167f)) * 0.15f;
            } else {
                this.leftArm.xRot = 0.0f;
                this.leftArm.yRot = 0.0f;
            }
            if (!((Lich)entity).getMainHandItem().isEmpty()) {
                this.rightArm.zRot = 0.0f;
                this.rightArm.yRot = -(0.1f - ogSin * 0.6f);
                this.rightArm.xRot = -1.5707964f;
                this.rightArm.xRot -= ogSin * 1.2f - otherSin * 0.4f;
                this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.26f)) * 0.15f + 0.05f;
                this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.167f)) * 0.15f;
            } else {
                this.rightArm.xRot = 0.0f;
                this.rightArm.yRot = 0.0f;
            }
        } else {
            float f = 1.0f;
            if (entity.getFallFlyingTicks() > 4) {
                f = (float)entity.getDeltaMovement().lengthSqr();
                f /= 0.2f;
                f *= f * f;
            }
            if (f < 1.0f) {
                f = 1.0f;
            }
            this.leftArm.xRot += -0.3926991f;
            this.rightArm.xRot -= Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f * 0.75f;
            this.rightArm.xRot += -1.1780972f;
        }
        this.body.skipDraw = flag = ((Lich)entity).deathTime > 115;
        this.leftArm.skipDraw = flag;
        this.rightArm.skipDraw = flag;
        this.leftLeg.skipDraw = flag;
        this.rightLeg.skipDraw = flag;
        this.cloak.skipDraw = flag;
        this.collar.skipDraw = flag;
        this.head.skipDraw = flag;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)LichRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
        this.hat.render(stack, consumer, light, overlay, color);
    }
}

