/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.DeathTome;

public class DeathTomeModel
extends HierarchicalModel<DeathTome> {
    private final ModelPart root;
    private final ModelPart book;
    private final ModelPart pagesRight;
    private final ModelPart pagesLeft;
    private final ModelPart flippingPageRight;
    private final ModelPart flippingPageLeft;
    private final ModelPart coverRight;
    private final ModelPart coverLeft;
    private final ModelPart paperStorm;
    private final ModelPart loosePage0;
    private final ModelPart loosePage1;
    private final ModelPart loosePage2;
    private final ModelPart loosePage3;

    public DeathTomeModel(ModelPart root) {
        this.root = root;
        this.book = root.getChild("book");
        this.pagesRight = this.book.getChild("pages_right");
        this.pagesLeft = this.book.getChild("pages_left");
        this.flippingPageRight = this.book.getChild("flipping_page_right");
        this.flippingPageLeft = this.book.getChild("flipping_page_left");
        this.coverRight = this.book.getChild("cover_right");
        this.coverLeft = this.book.getChild("cover_left");
        this.paperStorm = this.root.getChild("paper_storm");
        this.loosePage0 = this.paperStorm.getChild("loose_page_0");
        this.loosePage1 = this.paperStorm.getChild("loose_page_1");
        this.loosePage2 = this.paperStorm.getChild("loose_page_2");
        this.loosePage3 = this.paperStorm.getChild("loose_page_3");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition book = partdefinition.addOrReplaceChild("book", CubeListBuilder.create(), PartPose.ZERO);
        book.addOrReplaceChild("pages_right", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -4.0f, -0.99f, 5.0f, 8.0f, 1.0f), PartPose.ZERO);
        book.addOrReplaceChild("pages_left", CubeListBuilder.create().texOffs(12, 10).addBox(0.0f, -4.0f, -0.01f, 5.0f, 8.0f, 1.0f), PartPose.ZERO);
        book.addOrReplaceChild("flipping_page_right", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        book.addOrReplaceChild("flipping_page_left", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        book.addOrReplaceChild("cover_right", CubeListBuilder.create().addBox(-6.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        book.addOrReplaceChild("cover_left", CubeListBuilder.create().texOffs(16, 0).addBox(0.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        book.addOrReplaceChild("book_spine", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, -5.0f, 0.0f, 2.0f, 10.0f, 0.005f), PartPose.rotation((float)0.0f, (float)1.5707964f, (float)0.0f));
        PartDefinition paperStorm = partdefinition.addOrReplaceChild("paper_storm", CubeListBuilder.create(), PartPose.ZERO);
        paperStorm.addOrReplaceChild("loose_page_0", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, -8.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        paperStorm.addOrReplaceChild("loose_page_1", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, 9.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        paperStorm.addOrReplaceChild("loose_page_2", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, 11.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        paperStorm.addOrReplaceChild("loose_page_3", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, -4.0f, 7.0f, 5.0f, 8.0f, 0.005f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(DeathTome entity, float limbAngle, float limbDistance, float ageInTicks, float headYaw, float headPitch) {
        this.root.yRot = 1.5707964f;
        if (entity.isOnLectern()) {
            this.book.zRot = -1.1780972f;
            this.book.x = 1.75f;
        } else {
            this.book.zRot = -0.87266463f;
            this.book.x = 0.0f;
        }
        this.paperStorm.yRot = ageInTicks * ((float)Math.PI / 180) + 1.5707964f;
        this.paperStorm.zRot = 0.87266463f;
    }

    public void prepareMobModel(DeathTome entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        boolean onLectern = entity.isOnLectern();
        float bounce = onLectern ? 0.0f : (float)entity.tickCount + partialTicks;
        float open = onLectern ? 1.2f : 0.9f;
        float flip = Mth.lerp((float)partialTicks, (float)entity.oFlip, (float)entity.flip);
        float flipRight = Mth.clamp((float)(Mth.frac((float)(flip + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float flipLeft = Mth.clamp((float)(Mth.frac((float)(flip + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        this.loosePage0.skipDraw = onLectern;
        this.loosePage1.skipDraw = onLectern;
        this.loosePage2.skipDraw = onLectern;
        this.loosePage3.skipDraw = onLectern;
        this.loosePage0.yRot = bounce / 4.0f;
        this.loosePage0.xRot = Mth.sin((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage0.zRot = Mth.cos((float)(bounce / 5.0f)) / 5.0f;
        this.loosePage1.yRot = bounce / 3.0f;
        this.loosePage1.xRot = Mth.sin((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage1.zRot = Mth.cos((float)(bounce / 5.0f)) / 4.0f + 2.0f;
        this.loosePage2.yRot = bounce / 4.0f;
        this.loosePage2.xRot = -Mth.sin((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage2.zRot = Mth.cos((float)(bounce / 5.0f)) / 5.0f - 1.0f;
        this.loosePage3.yRot = bounce / 4.0f;
        this.loosePage3.xRot = -Mth.sin((float)(bounce / 2.0f)) / 4.0f;
        this.loosePage3.zRot = Mth.cos((float)(bounce / 7.0f)) / 5.0f;
        this.book.setPos(0.0f, 8.0f - Mth.sin((float)(bounce * 0.3f)) * 2.0f, 0.0f);
        float openAngle = (Mth.sin((float)(bounce * 0.4f)) * 0.3f + 1.25f) * open;
        this.coverRight.yRot = (float)Math.PI + openAngle;
        this.coverLeft.yRot = -openAngle;
        this.pagesRight.yRot = openAngle;
        this.pagesLeft.yRot = -openAngle;
        this.flippingPageRight.yRot = openAngle - openAngle * 2.0f * flipRight;
        this.flippingPageLeft.yRot = openAngle - openAngle * 2.0f * flipLeft;
        this.pagesRight.x = Mth.sin((float)openAngle);
        this.pagesLeft.x = Mth.sin((float)openAngle);
        this.flippingPageRight.x = Mth.sin((float)openAngle);
        this.flippingPageLeft.x = Mth.sin((float)openAngle);
    }
}

