/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.BeanContext;
import twilightforest.beanification.Configurable;
import twilightforest.block.ClimbableHollowLogBlock;
import twilightforest.enums.HollowLogVariants;
import twilightforest.util.DirectionUtil;

@Configurable
public class VerticalHollowLogBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape HOLLOW_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape COLLISION_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    @Autowired
    private DirectionUtil directionUtil;
    private final Holder<Block> climbable;

    public VerticalHollowLogBlock(BlockBehaviour.Properties properties, Holder<Block> climbable) {
        super(properties);
        this.climbable = climbable;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BeanContext.injectInto((Object)this);
    }

    private static boolean isInside(HitResult result, BlockPos pos) {
        Vec3 vec = result.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return 0.124 <= vec.x() && vec.x() <= 0.876 && 0.124 <= vec.z() && vec.z() <= 0.876;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return HOLLOW_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{WATERLOGGED}));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!VerticalHollowLogBlock.isInside((HitResult)hit, pos)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        if (stack.is(Blocks.VINE.asItem())) {
            level.setBlock(pos, (BlockState)((BlockState)((Block)this.climbable.value()).defaultBlockState().setValue(ClimbableHollowLogBlock.VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.VINE))).setValue((Property)ClimbableHollowLogBlock.FACING, (Comparable)this.directionUtil.horizontalOrElse(hit.getDirection(), player.getDirection().getOpposite())), 3);
            level.playSound(null, pos, SoundEvents.VINE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.is(Blocks.LADDER.asItem())) {
            level.setBlock(pos, (BlockState)((BlockState)((Block)this.climbable.value()).defaultBlockState().setValue(ClimbableHollowLogBlock.VARIANT, (Comparable)((Object)((Boolean)state.getValue((Property)WATERLOGGED) != false ? HollowLogVariants.Climbable.LADDER_WATERLOGGED : HollowLogVariants.Climbable.LADDER)))).setValue((Property)ClimbableHollowLogBlock.FACING, (Comparable)this.directionUtil.horizontalOrElse(hit.getDirection(), player.getDirection().getOpposite())), 3);
            level.playSound(null, pos, SoundEvents.LADDER_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos()).getFluidState().getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, neighborState, accessor, pos, neighborPos);
    }
}

