/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class VanishingBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.create((String)"vanished");
    private static final VoxelShape VANISHED_SHAPE = VanishingBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public VanishingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean areBlocksLocked(BlockGetter getter, BlockPos start) {
        int limit = 512;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        queue.offer(start);
        for (int iter = 0; !queue.isEmpty() && iter < limit; ++iter) {
            BlockPos cur = (BlockPos)queue.pop();
            BlockState state = getter.getBlockState(cur);
            if (state.getBlock() == TFBlocks.LOCKED_VANISHING_BLOCK.get() && ((Boolean)state.getValue((Property)LockedVanishingBlock.LOCKED)).booleanValue()) {
                return true;
            }
            checked.add(cur);
            if (!(state.getBlock() instanceof VanishingBlock)) continue;
            for (Direction facing : Direction.values()) {
                BlockPos neighbor = cur.relative(facing);
                if (checked.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    private boolean isVanished(BlockState state) {
        return state.hasProperty((Property)VANISHED) && (Boolean)state.getValue((Property)VANISHED) != false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? VANISHED_SHAPE : super.getShape(state, getter, pos, ctx);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? Shapes.empty() : super.getCollisionShape(state, getter, pos, ctx);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!this.isVanished(state) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (VanishingBlock.areBlocksLocked((BlockGetter)level, pos)) {
                level.playSound(null, pos, (SoundEvent)TFSounds.LOCKED_VANISHING_BLOCK.get(), SoundSource.BLOCKS, 1.0f, 0.3f);
            } else {
                this.activate(level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)ACTIVE) == false ? 6000.0f : super.getExplosionResistance(state, getter, pos, explosion);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return !((Boolean)state.getValue((Property)ACTIVE)).booleanValue() ? !VanishingBlock.areBlocksLocked(getter, pos) : super.canEntityDestroy(state, getter, pos, entity);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (!this.isVanished(state) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && level.hasNeighborSignal(pos) && !VanishingBlock.areBlocksLocked((BlockGetter)level, pos)) {
            this.activate(level, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isClientSide()) {
            return;
        }
        if (this.isVanished(state)) {
            if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)VANISHED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                level.scheduleTick(pos, (Block)this, 15);
            }
            level.playSound(null, pos, (SoundEvent)TFSounds.REAPPEAR_BLOCK.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (state.hasProperty((Property)VANISHED)) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)VANISHED, (Comparable)Boolean.valueOf(true)));
                level.scheduleTick(pos, (Block)this, 80);
            } else {
                level.removeBlock(pos, false);
            }
            level.playSound(null, pos, state.getBlock() == TFBlocks.REAPPEARING_BLOCK.get() ? (SoundEvent)TFSounds.REAPPEAR_POOF.get() : (SoundEvent)TFSounds.VANISHING_BLOCK.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            for (Direction e : Direction.values()) {
                this.activate((Level)level, pos.relative(e));
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            this.sparkle(level, pos);
        }
    }

    public void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Direction.Axis axis = direction.getAxis();
            double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    private void activate(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof VanishingBlock && !this.isVanished(state) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(pos, state.getBlock(), 2 + level.getRandom().nextInt(5));
        }
    }
}

