/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.compatibility.VisibleTraders;
import de.maxhenkel.tradecycling.mixin.MerchantMenuAccessor;
import de.maxhenkel.tradecycling.mixin.VillagerAccessor;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TradeCyclingMod {
    public static final String MODID = "trade_cycling";
    public static final Logger LOGGER = LogManager.getLogger((String)"trade_cycling");

    public void init() {
        VisibleTraders.init(this);
    }

    public abstract boolean isModLoaded(String var1);

    public static void onCycleTrades(@Nullable ServerPlayer player) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof MerchantMenuAccessor)) {
            return;
        }
        MerchantMenuAccessor merchantAccessor = (MerchantMenuAccessor)abstractContainerMenu;
        AbstractContainerMenu abstractContainerMenu2 = player.containerMenu;
        if (!(abstractContainerMenu2 instanceof MerchantMenu)) {
            return;
        }
        MerchantMenu container = (MerchantMenu)abstractContainerMenu2;
        Merchant merchant = merchantAccessor.getTrader();
        if (container.getTraderXp() > 0 && merchantAccessor.getTradeContainer().getActiveOffer() != null) {
            return;
        }
        if (!(merchant instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)merchant;
        if (!(merchant instanceof VillagerAccessor)) {
            return;
        }
        VillagerAccessor villagerAccessor = (VillagerAccessor)merchant;
        if (villager.getBrain().getMemory(MemoryModuleType.JOB_SITE).isEmpty()) {
            return;
        }
        villager.setOffers(null);
        villager.getOffers();
        villagerAccessor.invokeUpdateSpecialPrices((Player)player);
        villager.setTradingPlayer((Player)player);
        VisibleTraders.forceTradeGeneration(villager);
        TradeCyclingMod.sendOffers(player, container.containerId, villager);
    }

    private static void sendOffers(ServerPlayer player, int containerId, Villager villager) {
        boolean success = VisibleTraders.sendTrades(player, (Merchant)villager, containerId, villager.getOffers(), villager.getVillagerData().getLevel(), villager.getVillagerXp(), villager.showProgressBar(), villager.canRestock());
        if (success) {
            return;
        }
        player.sendMerchantOffers(containerId, villager.getOffers(), villager.getVillagerData().getLevel(), villager.getVillagerXp(), villager.showProgressBar(), villager.canRestock());
    }
}

