/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class CinderEffect
implements ITooltipEffect {
    private static final int CINDERS_CAP = 14;
    private static final long PER_PARTICLE = 110L;
    private static final float MIN_DISP = -12.0f;
    private static final float MAX_DISP = -22.0f;
    private static final float TOKYO_DRIFT = 9.0f;
    private static final int COLOR_START = -855645528;
    private static final int COLOR_END = -1711300512;
    private final Deque<Cinder> cinders = new ArrayDeque<Cinder>();
    private long lastSpawn = 0L;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        int x = (int)pos.x;
        int y = (int)pos.y;
        int w = size.x;
        int h = size.y;
        long now = System.currentTimeMillis();
        if (now - this.lastSpawn >= 110L && this.cinders.size() < 14) {
            this.spawn(x, y, w, h, now);
            this.lastSpawn = now;
        }
        ctx.push(() -> {
            ctx.graphics().enableScissor(x - 3, y - 3, x + w + 3, y + h + 3);
            ctx.translate(0.0f, 0.0f, depth.getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.cinders.removeIf(c -> !c.render(ctx, 0.016666668f, now));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            ctx.graphics().disableScissor();
        });
    }

    private void spawn(int x, int y, int w, int h, long now) {
        Random random = new Random();
        float sx = (float)(x + 4) + random.nextFloat() * (float)(w - 8);
        float sy = (float)(y + h - 2) - random.nextFloat() * 2.0f;
        float vel = -12.0f + random.nextFloat() * -10.0f;
        float life = 450.0f + random.nextFloat() * 350.0f;
        float size = 1.0f + random.nextFloat();
        float accel = (random.nextFloat() * 2.0f - 1.0f) * 9.0f;
        float rot = random.nextFloat() * (float)Math.PI;
        if (this.cinders.size() >= 14) {
            this.cinders.pollFirst();
        }
        this.cinders.addLast(new Cinder(sx, sy, vel, accel, size, now, life, rot));
    }

    private static void drawStar(Matrix4f pose, float cx, float cy, float len, float thickness, float rot, int r, int g, int b, int a) {
        for (int i = 0; i < 4; ++i) {
            float rot2 = rot + (float)i * 1.5707964f;
            CinderEffect.drawSegment(pose, cx, cy, cx + (float)Math.cos(rot2) * len, cy + (float)Math.sin(rot2) * len, thickness, Math.max(0.6f, thickness * 0.6f), r, g, b, a);
        }
    }

    private static void drawSegment(Matrix4f pose, float x1, float y1, float x2, float y2, float tStart, float tEnd, int r, int g, int b, int a) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.max(0.001, Math.hypot(dx, dy));
        float nx = -dy / len;
        float ny = dx / len;
        float hsx = nx * tStart * 0.5f;
        float hsy = ny * tStart * 0.5f;
        float hex = nx * tEnd * 0.5f;
        float hey = ny * tEnd * 0.5f;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        buf.addVertex(pose, x1 - hsx, y1 - hsy, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x1 + hsx, y1 + hsy, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 - hex, y2 - hey, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 + hex, y2 + hey, 0.0f).setColor(r, g, b, a);
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private static final class Cinder {
        private float x;
        private float y;
        private float vy;
        private float ax;
        private float size;
        private float baseRot;
        private long start;
        private float lifeitme;

        public Cinder(float x, float y, float vy, float ax, float size, long birth, float lifeitme, float baseRot) {
            this.x = x;
            this.y = y;
            this.vy = vy;
            this.ax = ax;
            this.size = size;
            this.start = birth;
            this.lifeitme = lifeitme;
            this.baseRot = baseRot;
        }

        boolean render(TooltipContext ctx, float dt, long now) {
            float age = now - this.start;
            if (age >= this.lifeitme) {
                return false;
            }
            this.x += this.ax * dt * 0.25f;
            this.y += this.vy * dt;
            float k = age / this.lifeitme;
            float drop = 0.85f + 0.15f * (float)Math.sin((float)now * 0.02f + this.x * 0.1f);
            int startt = (int)((1.0f - k) * 200.0f * drop);
            int endd = (int)((1.0f - k) * 120.0f * drop);
            if (startt <= 0 && endd <= 0) {
                return true;
            }
            float rot = this.baseRot + (float)Math.sin((double)this.start * 0.0017 + (double)now * 0.0011 + (double)(this.x * 0.03f)) * 0.15f;
            Matrix4f pose = ctx.pose().last().pose();
            float length = (2.5f + this.size * 2.2f) * 0.35f;
            float thick = 0.9f + this.size * 0.7f;
            float lenGlow = length * 1.35f;
            float thickGlow = thick * 1.35f;
            int rw = 255;
            int gw = 160;
            int bw = 96;
            CinderEffect.drawStar(pose, this.x, this.y, lenGlow, thickGlow, rot, rw, gw, bw, endd);
            int rh = 255;
            int gh = 226;
            int bh = 168;
            CinderEffect.drawStar(pose, this.x, this.y, length, thick, rot, rh, gh, bh, startt);
            return true;
        }
    }
}

