/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.api.sizing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.sizing.DoorType;
import earth.terrarium.tempad.api.sizing.SizingType;
import earth.terrarium.tempad.api.sizing.TimedoorPlacementSettings;
import earth.terrarium.tempad.common.entity.TimedoorEntity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u00020\u0012*\u00020%2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016X\u0096\u0004\u00a2\u0006\n\n\u0002\b\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Learth/terrarium/tempad/api/sizing/FloorPlacementSettings;", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "xOffset", "", "yOffset", "zOffset", "<init>", "(FFF)V", "()V", "getXOffset", "()F", "getYOffset", "getZOffset", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "getDimensions", "()Lnet/minecraft/world/entity/EntityDimensions;", "showLineAnimation", "", "getShowLineAnimation", "()Z", "type", "Learth/terrarium/tempad/api/sizing/SizingType;", "getType", "()Learth/terrarium/tempad/api/sizing/SizingType;", "type$1", "widthAtPercent", "percent", "heightAtPercent", "depthAtPercent", "placeTimedoor", "", "Learth/terrarium/tempad/api/sizing/DoorType;", "anchor", "Lnet/minecraft/world/phys/Vec3;", "angle", "timedoor", "Learth/terrarium/tempad/common/entity/TimedoorEntity;", "isInside", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "tempad-1.21.1"})
public final class FloorPlacementSettings
implements TimedoorPlacementSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float xOffset;
    private final float yOffset;
    private final float zOffset;
    @NotNull
    private final EntityDimensions dimensions;
    private final boolean showLineAnimation;
    @NotNull
    private final SizingType<?> type$1;
    @NotNull
    private static final SizingType<FloorPlacementSettings> type;
    private static final float width;
    private static final float height;
    private static final float depth;

    public FloorPlacementSettings(float xOffset, float yOffset, float zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        EntityDimensions entityDimensions = EntityDimensions.fixed((float)width, (float)height);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"fixed(...)");
        this.dimensions = entityDimensions;
        this.type$1 = type;
    }

    public final float getXOffset() {
        return this.xOffset;
    }

    public final float getYOffset() {
        return this.yOffset;
    }

    public final float getZOffset() {
        return this.zOffset;
    }

    public FloorPlacementSettings() {
        this(0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public EntityDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean getShowLineAnimation() {
        return this.showLineAnimation;
    }

    @Override
    @NotNull
    public SizingType<?> getType() {
        return this.type$1;
    }

    @Override
    public float widthAtPercent(float percent) {
        if ((double)percent < 0.5) {
            return width * percent * (float)2;
        }
        return width;
    }

    @Override
    public float heightAtPercent(float percent) {
        return height;
    }

    @Override
    public float depthAtPercent(float percent) {
        if ((double)percent > 0.5) {
            return Mth.lerp((float)((percent - 0.5f) * (float)2), (float)0.2f, (float)depth);
        }
        return 0.2f;
    }

    @Override
    public void placeTimedoor(@NotNull DoorType type2, @NotNull Vec3 anchor, float angle, @NotNull TimedoorEntity timedoor) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)timedoor), (String)"timedoor");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                timedoor.setPos(anchor.x + (double)this.xOffset, anchor.y + (double)this.yOffset, anchor.z + (double)this.zOffset);
                break;
            }
            case 2: {
                timedoor.setPos(anchor.x, anchor.y + (double)2.4f, anchor.z);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public boolean isInside(@NotNull TimedoorEntity $this$isInside, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isInside), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return true;
    }

    private static final Float type$lambda$0(FloorPlacementSettings it) {
        return Float.valueOf(it.xOffset);
    }

    private static final Float type$lambda$1(FloorPlacementSettings it) {
        return Float.valueOf(it.yOffset);
    }

    private static final Float type$lambda$2(FloorPlacementSettings it) {
        return Float.valueOf(it.zOffset);
    }

    private static final Float type$lambda$6$lambda$3(FloorPlacementSettings it) {
        return Float.valueOf(it.yOffset);
    }

    private static final Float type$lambda$6$lambda$4(FloorPlacementSettings it) {
        return Float.valueOf(it.yOffset);
    }

    private static final Float type$lambda$6$lambda$5(FloorPlacementSettings it) {
        return Float.valueOf(it.yOffset);
    }

    private static final App type$lambda$6(RecordCodecBuilder.Instance it) {
        return it.group((App)Codec.FLOAT.fieldOf("x").forGetter(FloorPlacementSettings::type$lambda$6$lambda$3), (App)Codec.FLOAT.fieldOf("y").forGetter(FloorPlacementSettings::type$lambda$6$lambda$4), (App)Codec.FLOAT.fieldOf("z").forGetter(FloorPlacementSettings::type$lambda$6$lambda$5)).apply((Applicative)it, FloorPlacementSettings::new);
    }

    static {
        ResourceLocation resourceLocation = TempadKt.getTempadId("floor");
        ByteCodec byteCodec2 = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(FloorPlacementSettings::type$lambda$0), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(FloorPlacementSettings::type$lambda$1), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(FloorPlacementSettings::type$lambda$2), FloorPlacementSettings::new);
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"create(...)");
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(FloorPlacementSettings::type$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        type = new SizingType(resourceLocation, byteCodec2, mapCodec);
        width = 1.25f;
        height = 0.25f;
        depth = 1.25f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Learth/terrarium/tempad/api/sizing/FloorPlacementSettings$Companion;", "", "<init>", "()V", "type", "Learth/terrarium/tempad/api/sizing/SizingType;", "Learth/terrarium/tempad/api/sizing/FloorPlacementSettings;", "kotlin.jvm.PlatformType", "getType", "()Learth/terrarium/tempad/api/sizing/SizingType;", "width", "", "getWidth", "()F", "height", "getHeight", "depth", "getDepth", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SizingType<FloorPlacementSettings> getType() {
            return type;
        }

        public final float getWidth() {
            return width;
        }

        public final float getHeight() {
            return height;
        }

        public final float getDepth() {
            return depth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DoorType.values().length];
            try {
                nArray[DoorType.ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.EXIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

