/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.globe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.ByteBuffer;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeTextureGenerator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class GlobeData
extends WorldSavedData {
    public static final Codec<GlobeData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BYTE_BUFFER.xmap(ByteBuffer::array, ByteBuffer::wrap).fieldOf("pixels").forGetter(g -> g.globePixels), (App)Codec.LONG.fieldOf("seed").forGetter(g -> g.seed)).apply((Applicative)i, GlobeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlobeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE_ARRAY, g -> g.globePixels, (StreamCodec)ByteBufCodecs.VAR_LONG, g -> g.seed, GlobeData::new);
    private static final int TEXTURE_H = 16;
    private static final int TEXTURE_W = 32;
    private final byte[] globePixels;
    private final long seed;

    private GlobeData(byte[] flattenedPixels, long seed) {
        this.globePixels = flattenedPixels;
        this.seed = seed;
    }

    public static GlobeData createFromLevel(ServerLevel level) {
        return GlobeData.createFromSeed(level.getSeed());
    }

    public static GlobeData createFromSeed(long seed) {
        byte[][] generate = GlobeTextureGenerator.generate(seed);
        byte[] flattened = new byte[512];
        for (int x = 0; x < 32; ++x) {
            System.arraycopy(generate[x], 0, flattened, x * 16, 16);
        }
        return new GlobeData(flattened, seed);
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || x >= 32 || y < 0 || y >= 16) {
            return 0;
        }
        return this.globePixels[x * 16 + y];
    }

    public int getTextureHeight() {
        return 16;
    }

    public int getTextureWidth() {
        return 32;
    }

    public WorldSavedDataType<GlobeData> getType() {
        return ModRegistry.GLOBE_DATA;
    }

    public void onReassigned(Level level) {
        if (level.isClientSide) {
            GlobeManager.refreshTextures();
        }
    }

    public static void recreateAndAssignFromSeed(ServerLevel level, long seed) {
        GlobeData generate = GlobeData.createFromSeed(seed);
        ModRegistry.GLOBE_DATA.setData((Level)level, (WorldSavedData)generate);
        generate.sync();
    }
}

