/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.EnderPearlBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.FireworkBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.PopperBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SimpleProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SkibidiBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SlingshotBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SpawnEggBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SpawnMobBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SpitItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.TntBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public class FireBehaviorsManager {
    private static final Map<Item, IFireItemBehavior> CANNON_FIRE_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final IFireItemBehavior CANNON_DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SlingshotBehavior());
    private static final Map<Item, IFireItemBehavior> PRESENT_FIRE_BEHAVIORS = new IdentityHashMap<Item, IFireItemBehavior>();
    private static final IFireItemBehavior PRESENT_DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SpitItemBehavior());

    public static synchronized void registerCannonBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        CANNON_FIRE_BEHAVIORS.put(pItem.asItem(), pBehavior);
    }

    public static IFireItemBehavior getCannonBehavior(ItemLike item) {
        return CANNON_FIRE_BEHAVIORS.getOrDefault(item, CANNON_DEFAULT);
    }

    public static synchronized void registerPresentBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        PRESENT_FIRE_BEHAVIORS.put(pItem.asItem(), pBehavior);
    }

    public static IFireItemBehavior getPresentBehavior(ItemLike item) {
        return PRESENT_FIRE_BEHAVIORS.getOrDefault(item, PRESENT_DEFAULT);
    }

    @ApiStatus.Internal
    public static void registerBehaviors(RegistryAccess access) {
        CANNON_FIRE_BEHAVIORS.clear();
        PRESENT_FIRE_BEHAVIORS.clear();
        TntBehavior tnt = new TntBehavior();
        SpawnEggBehavior spawnEgg = new SpawnEggBehavior();
        SpawnMobBehavior spawnArmorStand = new SpawnMobBehavior(EntityType.ARMOR_STAND);
        FireworkBehavior firework = new FireworkBehavior();
        EnderPearlBehavior enderPearl = new EnderPearlBehavior();
        PopperBehavior popper = new PopperBehavior();
        SimpleProjectileBehavior fireBall = new SimpleProjectileBehavior(EntityType.SMALL_FIREBALL, 1.0f);
        SimpleProjectileBehavior<CannonBallEntity> cannonBall = new SimpleProjectileBehavior<CannonBallEntity>(ModEntities.CANNONBALL.get(), 0.9f);
        for (Item i : BuiltInRegistries.ITEM) {
            BlockItem bi;
            if (i instanceof BlockItem && TntBehavior.isTNTLikeBlock((bi = (BlockItem)i).getBlock().defaultBlockState())) {
                FireBehaviorsManager.registerPresentBehavior((ItemLike)i, tnt);
                if (CommonConfigs.Functional.CANNON_EXPLODE_TNT.get() == CommonConfigs.TNTMode.IGNITE) {
                    FireBehaviorsManager.registerCannonBehavior((ItemLike)i, tnt);
                }
            }
            if (!(i instanceof SpawnEggItem)) continue;
            SpawnEggItem sp = (SpawnEggItem)i;
            FireBehaviorsManager.registerPresentBehavior((ItemLike)sp, spawnEgg);
            FireBehaviorsManager.registerCannonBehavior((ItemLike)sp, spawnEgg);
        }
        FireBehaviorsManager.registerPresentBehavior((ItemLike)ModRegistry.CONFETTI_POPPER.get(), popper);
        FireBehaviorsManager.registerCannonBehavior((ItemLike)ModRegistry.CONFETTI_POPPER.get(), popper);
        FireBehaviorsManager.registerPresentBehavior((ItemLike)Items.ENDER_PEARL, enderPearl);
        FireBehaviorsManager.registerCannonBehavior((ItemLike)Items.ENDER_PEARL, enderPearl);
        if (!CompatHandler.AMENDMENTS || !AmendmentsCompat.hasThrowableFireCharge()) {
            FireBehaviorsManager.registerPresentBehavior((ItemLike)Items.FIRE_CHARGE, fireBall);
            FireBehaviorsManager.registerCannonBehavior((ItemLike)Items.FIRE_CHARGE, fireBall);
        }
        FireBehaviorsManager.registerCannonBehavior((ItemLike)ModRegistry.CANNONBALL.get(), cannonBall);
        FireBehaviorsManager.registerPresentBehavior((ItemLike)Items.FIREWORK_ROCKET, firework);
        FireBehaviorsManager.registerCannonBehavior((ItemLike)Items.FIREWORK_ROCKET, firework);
        FireBehaviorsManager.registerPresentBehavior((ItemLike)ModRegistry.HAT_STAND.get(), new SkibidiBehavior());
        FireBehaviorsManager.registerCannonBehavior((ItemLike)ModRegistry.HAT_STAND.get(), new SpawnMobBehavior(ModEntities.HAT_STAND.get()));
        FireBehaviorsManager.registerPresentBehavior((ItemLike)Items.ARMOR_STAND, spawnArmorStand);
        FireBehaviorsManager.registerCannonBehavior((ItemLike)Items.ARMOR_STAND, spawnArmorStand);
    }
}

