/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxModelsManager
extends SimpleJsonResourceReloadListener {
    public static final FlowerBoxModelsManager INSTANCE = new FlowerBoxModelsManager();
    private final Map<Item, FlowerBoxPlant> flowers = new IdentityHashMap<Item, FlowerBoxPlant>();

    public FlowerBoxModelsManager() {
        super(new Gson(), "flower_box_plants");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.flowers.clear();
        Codec codec = ForgeHelper.conditionalCodec(FlowerBoxPlant.CODEC);
        jsonMap.forEach((key, json) -> {
            try {
                FlowerBoxPlant result = (FlowerBoxPlant)((Optional)codec.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow()).get();
                for (Item item : result.seedItems) {
                    this.flowers.put(item, result);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for hourglass data {}", key, (Object)e);
            }
        });
    }

    @Nullable
    public ModelResourceLocation getSpecialFlowerModel(Item i) {
        ModelResourceLocation res;
        FlowerBoxModelsManager instance = INSTANCE;
        if (instance == null) {
            return null;
        }
        FlowerBoxPlant flower = instance.flowers.get(i);
        if (flower == null) {
            return null;
        }
        if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue() && (res = flower.tallModel) != null) {
            return res;
        }
        res = flower.normalModel;
        return res;
    }

    private record FlowerBoxPlant(List<Item> seedItems, ModelResourceLocation tallModel, ModelResourceLocation normalModel) {
        public static final Codec<FlowerBoxPlant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiscUtils.LENIENT_ITEM_OR_ITEM_LIST.lenientOptionalFieldOf("items", List.of()).forGetter(FlowerBoxPlant::seedItems), (App)ResourceLocation.CODEC.optionalFieldOf("big_model").forGetter(f -> Optional.ofNullable(f.tallModel).map(ModelResourceLocation::id)), (App)ResourceLocation.CODEC.optionalFieldOf("small_model").forGetter(f -> Optional.ofNullable(f.normalModel).map(ModelResourceLocation::id))).apply((Applicative)instance, FlowerBoxPlant::new));

        private FlowerBoxPlant(List<Item> item, Optional<ResourceLocation> tallModel, Optional<ResourceLocation> normalModel) {
            this(item, (ModelResourceLocation)tallModel.map(RenderUtil::getStandaloneModelLocation).orElse(null), (ModelResourceLocation)normalModel.map(RenderUtil::getStandaloneModelLocation).orElse(null));
        }
    }
}

