/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.platform.PlatformHooks;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class StructurifyConfig {
    private static final Path BACKUP_CONFIG_DIR = Path.of("config/structurify", new String[0]);
    private static final String BACKUP_PREFIX = "structurify_backup_";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    public boolean isLoaded = false;
    public boolean isLoading = false;
    private final Path configPath = Path.of("config", "structurify.json");
    public final Path configDumpPath = Path.of("config", "structurify_dump.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean disableAllStructures = false;
    public int minStructureDistanceFromWorldCenter = 0;
    public boolean enableGlobalSpacingAndSeparationModifier = false;
    public double globalSpacingAndSeparationModifier = 1.0;
    private Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    public static final boolean ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_DEFAULT_VALUE = false;
    public static final double GLOBAL_SPACING_AND_SEPARATION_MODIFIER_DEFAULT_VALUE = 1.0;
    private static final String CONFIG_VERSION_PROPERTY = "config_version";
    private static final String CONFIG_DATETIME_PROPERTY = "config_datetime";
    private static final String GENERAL_PROPERTY = "general";
    private static final String MIN_STRUCTURE_DISTANCE_FROM_WORLD_CENTER_PROPERTY = "min_structure_distance_from_world_center";
    private static final String DISABLE_ALL_STRUCTURES_PROPERTY = "disable_all_structures";
    private static final String ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY = "enable_global_spacing_and_separation_modifier";
    private static final String GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY = "global_spacing_and_separation_modifier";
    private static final String STRUCTURES_PROPERTY = "structures";
    private static final String NAME_PROPERTY = "name";
    private static final String IS_DISABLED_PROPERTY = "is_disabled";
    private static final String ENABLE_FLATNESS_CHECK_PROPERTY = "enable_flatness_check";
    private static final String FLATNESS_CHECK_DISTANCE_PROPERTY = "flatness_check_distance";
    private static final String FLATNESS_CHECK_THRESHOLD_PROPERTY = "flatness_check_threshold";
    private static final String ENABLE_BIOME_CHECK_PROPERTY = "enable_biome_check";
    private static final String BIOME_CHECK_DISTANCE_PROPERTY = "biome_check_distance";
    private static final String BIOME_CHECK_MODE_PROPERTY = "biome_check_mode";
    private static final String BIOME_CHECK_BLACKLISTED_BIOMES_PROPERTY = "biome_check_blacklisted_biomes";
    private static final String BIOMES_PROPERTY = "biomes";
    private static final String WHITELISTED_BIOMES_PROPERTY = "whitelisted_biomes";
    private static final String BLACKLISTED_BIOMES_PROPERTY = "blacklisted_biomes";
    private static final String STRUCTURE_SETS_PROPERTY = "structure_sets";
    private static final String SALT_PROPERTY = "salt";
    private static final String FREQUENCY_PROPERTY = "frequency";
    private static final String OVERRIDE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY = "override_global_spacing_and_separation_modifier";
    private static final String SPACING_PROPERTY = "spacing";
    private static final String SEPARATION_PROPERTY = "separation";

    public Map<String, StructureData> getStructureData() {
        return this.structureData;
    }

    public Map<String, StructureSetData> getStructureSetData() {
        return this.structureSetData;
    }

    public void create() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            return;
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.isLoading) {
            return;
        }
        try {
            Structurify.getLogger().info("Loading Structurify config...");
            this.isLoading = true;
            WorldgenDataProvider.loadWorldgenData();
            this.structureData = WorldgenDataProvider.getStructures();
            this.structureSetData = WorldgenDataProvider.getStructureSets();
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                return;
            }
            String jsonString = Files.readString(this.configPath);
            JsonObject json = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            if (json.has(GENERAL_PROPERTY)) {
                JsonObject general = json.getAsJsonObject(GENERAL_PROPERTY);
                if (general.has(DISABLE_ALL_STRUCTURES_PROPERTY)) {
                    this.disableAllStructures = general.get(DISABLE_ALL_STRUCTURES_PROPERTY).getAsBoolean();
                }
                if (general.has(MIN_STRUCTURE_DISTANCE_FROM_WORLD_CENTER_PROPERTY)) {
                    this.minStructureDistanceFromWorldCenter = general.get(MIN_STRUCTURE_DISTANCE_FROM_WORLD_CENTER_PROPERTY).getAsInt();
                }
                if (general.has(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY)) {
                    this.enableGlobalSpacingAndSeparationModifier = general.get(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY).getAsBoolean();
                }
                if (general.has(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY)) {
                    this.globalSpacingAndSeparationModifier = (double)Math.round(general.get(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY).getAsDouble() * 10.0) / 10.0;
                }
            }
            if (json.has(STRUCTURES_PROPERTY)) {
                JsonArray structures = json.getAsJsonArray(STRUCTURES_PROPERTY);
                for (JsonElement structure : structures) {
                    JsonObject structureJson = structure.getAsJsonObject();
                    if (!(structureJson.has(NAME_PROPERTY) && structureJson.has(IS_DISABLED_PROPERTY) && structureJson.has(ENABLE_BIOME_CHECK_PROPERTY) && structureJson.has(BIOME_CHECK_DISTANCE_PROPERTY) && (structureJson.has(BIOMES_PROPERTY) || structureJson.has(WHITELISTED_BIOMES_PROPERTY) && structureJson.has(BLACKLISTED_BIOMES_PROPERTY)))) {
                        Structurify.getLogger().info("Found invalid structure entry, skipping.");
                        continue;
                    }
                    if (!this.structureData.containsKey(structureJson.get(NAME_PROPERTY).getAsString())) {
                        Structurify.getLogger().info("Found invalid structure identifier of \"{}\", skipping.", (Object)structureJson.get(NAME_PROPERTY).getAsString());
                        continue;
                    }
                    StructureData structureData = this.structureData.get(structureJson.get(NAME_PROPERTY).getAsString());
                    structureData.setDisabled(structureJson.get(IS_DISABLED_PROPERTY).getAsBoolean());
                    if (structureJson.has(ENABLE_FLATNESS_CHECK_PROPERTY)) {
                        boolean isFlatnessCheckEnabled = structureJson.get(ENABLE_FLATNESS_CHECK_PROPERTY).getAsBoolean();
                        structureData.setEnableFlatnessCheck(isFlatnessCheckEnabled);
                    }
                    if (structureJson.has(FLATNESS_CHECK_DISTANCE_PROPERTY)) {
                        int flatnessCheckDistance = structureJson.get(FLATNESS_CHECK_DISTANCE_PROPERTY).getAsInt();
                        structureData.setFlatnessCheckDistance(flatnessCheckDistance);
                    }
                    if (structureJson.has(FLATNESS_CHECK_THRESHOLD_PROPERTY)) {
                        int flatnessCheckThreshold = structureJson.get(FLATNESS_CHECK_THRESHOLD_PROPERTY).getAsInt();
                        structureData.setFlatnessCheckThreshold(flatnessCheckThreshold);
                    }
                    boolean isBiomeCheckEnabled = structureJson.get(ENABLE_BIOME_CHECK_PROPERTY).getAsBoolean();
                    structureData.setEnableBiomeCheck(isBiomeCheckEnabled);
                    int biomeCheckDistance = structureJson.get(BIOME_CHECK_DISTANCE_PROPERTY).getAsInt();
                    structureData.setBiomeCheckDistance(biomeCheckDistance);
                    if (!structureJson.has(BIOME_CHECK_MODE_PROPERTY)) {
                        structureData.setBiomeCheckMode(StructureData.BiomeCheckMode.STRICT);
                        structureData.setBiomeCheckBlacklistedBiomes(StructureData.BIOME_CHECK_BLACKLISTED_BIOMES_DEFAULT_VALUE);
                    } else {
                        String biomeCheckMode = structureJson.get(BIOME_CHECK_MODE_PROPERTY).getAsString();
                        structureData.setBiomeCheckMode(StructureData.BiomeCheckMode.valueOf(biomeCheckMode));
                        List<String> biomeCheckBlacklistedBiomes = StreamSupport.stream(structureJson.getAsJsonArray(BIOME_CHECK_BLACKLISTED_BIOMES_PROPERTY).spliterator(), false).map(JsonElement::getAsString).toList();
                        structureData.setBiomeCheckBlacklistedBiomes(biomeCheckBlacklistedBiomes);
                    }
                    ArrayList<String> biomes = new ArrayList<String>(structureData.getDefaultBiomes());
                    if (structureJson.has(BIOMES_PROPERTY)) {
                        whitelistedBiomes = structureJson.getAsJsonArray(BIOMES_PROPERTY).asList().stream().map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new));
                        ((ArrayList)whitelistedBiomes).removeAll(structureData.getDefaultBiomes());
                        whitelistedBiomes.stream().distinct().forEach(biomes::add);
                        blacklistedBiomes = new ArrayList<String>(structureData.getDefaultBiomes());
                        ((ArrayList)blacklistedBiomes).removeAll(structureJson.getAsJsonArray(BIOMES_PROPERTY).asList().stream().map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new)));
                        blacklistedBiomes.stream().distinct().forEach(biomes::remove);
                    } else {
                        Object whitelistedBiome;
                        whitelistedBiomes = structureJson.getAsJsonArray(WHITELISTED_BIOMES_PROPERTY);
                        blacklistedBiomes = whitelistedBiomes.iterator();
                        while (blacklistedBiomes.hasNext()) {
                            whitelistedBiome = (JsonElement)blacklistedBiomes.next();
                            if (biomes.contains(whitelistedBiome.getAsString())) continue;
                            biomes.add(whitelistedBiome.getAsString());
                        }
                        blacklistedBiomes = structureJson.getAsJsonArray(BLACKLISTED_BIOMES_PROPERTY);
                        whitelistedBiome = blacklistedBiomes.iterator();
                        while (whitelistedBiome.hasNext()) {
                            JsonElement blacklistedBiome = (JsonElement)whitelistedBiome.next();
                            if (!biomes.contains(blacklistedBiome.getAsString())) continue;
                            biomes.remove(blacklistedBiome.getAsString());
                        }
                    }
                    structureData.setBiomes(biomes);
                }
            }
            if (json.has(STRUCTURE_SETS_PROPERTY)) {
                JsonArray structureSets = json.getAsJsonArray(STRUCTURE_SETS_PROPERTY);
                for (JsonElement structureSet : structureSets) {
                    int separation;
                    JsonObject structureSpreadJson = structureSet.getAsJsonObject();
                    if (!structureSpreadJson.has(NAME_PROPERTY)) {
                        Structurify.getLogger().info("Found invalid structure set entry, skipping.");
                        continue;
                    }
                    String structureSetName = structureSpreadJson.get(NAME_PROPERTY).getAsString();
                    if (!this.structureSetData.containsKey(structureSetName)) {
                        Structurify.getLogger().info("Found invalid structure set identifier of \"{}\", skipping.", (Object)structureSetName);
                        continue;
                    }
                    StructureSetData structureSetData = this.structureSetData.get(structureSetName);
                    int salt = structureSpreadJson.has(SALT_PROPERTY) ? structureSpreadJson.get(SALT_PROPERTY).getAsInt() : structureSetData.getDefaultSalt();
                    float frequency = structureSpreadJson.has(FREQUENCY_PROPERTY) ? structureSpreadJson.get(FREQUENCY_PROPERTY).getAsFloat() : structureSetData.getDefaultFrequency();
                    int spacing = structureSpreadJson.has(SPACING_PROPERTY) ? structureSpreadJson.get(SPACING_PROPERTY).getAsInt() : structureSetData.getDefaultSpacing();
                    int n = separation = structureSpreadJson.has(SEPARATION_PROPERTY) ? structureSpreadJson.get(SEPARATION_PROPERTY).getAsInt() : structureSetData.getDefaultSeparation();
                    if ((salt < 0 || salt > Integer.MAX_VALUE) && salt != structureSetData.getDefaultSalt()) {
                        Structurify.getLogger().info("Salt value for structure set {} is currently {}, which is invalid, value will be automatically corrected to {}.", new Object[]{structureSetName, salt, structureSetData.getDefaultSalt()});
                        salt = structureSetData.getDefaultSalt();
                    }
                    if (frequency < 0.0f || frequency > 1.0f) {
                        Structurify.getLogger().info("Frequency value for structure set {} is currently {}, which is invalid, value will be automatically corrected to {}.", new Object[]{structureSetName, Float.valueOf(frequency), Float.valueOf(structureSetData.getDefaultFrequency())});
                        frequency = structureSetData.getDefaultFrequency();
                    }
                    if (separation >= spacing) {
                        Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is bigger than spacing {}, value will be automatically corrected to {}.", new Object[]{structureSetName, separation, spacing, spacing - 1});
                        separation = spacing - 1;
                    }
                    if (separation < 0) {
                        Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)separation);
                        separation = 0;
                    }
                    if (spacing < 1) {
                        Structurify.getLogger().info("Spacing value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)spacing);
                        separation = 0;
                    }
                    boolean overrideGlobalSpacingAndSeparationModifier = structureSpreadJson.get(OVERRIDE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY).getAsBoolean();
                    structureSetData.setSalt(salt);
                    structureSetData.setFrequency(frequency);
                    structureSetData.setOverrideGlobalSpacingAndSeparationModifier(overrideGlobalSpacingAndSeparationModifier);
                    structureSetData.setSpacing(spacing);
                    structureSetData.setSeparation(separation);
                }
            }
            Structurify.getLogger().info("Structurify config loaded");
            this.isLoaded = true;
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to load Structurify config");
            e.printStackTrace();
        }
        finally {
            this.isLoading = false;
        }
    }

    public void save() {
        Structurify.getLogger().info("Saving Structurify config...");
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                Path backupConfigPath = this.getBackupConfigPath();
                if (!Files.exists(BACKUP_CONFIG_DIR, new LinkOption[0]) || !Files.isDirectory(BACKUP_CONFIG_DIR, new LinkOption[0])) {
                    Files.createDirectories(BACKUP_CONFIG_DIR, new FileAttribute[0]);
                }
                if (!Files.exists(backupConfigPath, new LinkOption[0])) {
                    Files.move(this.configPath, backupConfigPath, new CopyOption[0]);
                }
            }
            JsonObject json = new JsonObject();
            json.addProperty(CONFIG_VERSION_PROPERTY, PlatformHooks.PLATFORM_HELPER.getModVersion());
            json.addProperty(CONFIG_DATETIME_PROPERTY, LocalDateTime.now().format(DATETIME_FORMATTER));
            this.saveGeneralData(json);
            this.saveStructuresData(json, true);
            this.saveStructureSetsData(json, true);
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.createFile(this.configPath, new FileAttribute[0]);
            Files.writeString(this.configPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
            Structurify.getLogger().info("Structurify config saved");
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to save Structurify config");
            e.printStackTrace();
            try {
                Path possibleLatestBackupConfigPath = this.getLatestBackupConfigPath();
                if (possibleLatestBackupConfigPath != null) {
                    Structurify.getLogger().error("Restoring Structurify backup config...");
                    if (Files.exists(this.configPath, new LinkOption[0])) {
                        Files.delete(this.configPath);
                    }
                    Files.move(possibleLatestBackupConfigPath, this.configPath, new CopyOption[0]);
                }
            }
            catch (Exception fe) {
                Structurify.getLogger().error("Failed to restore Structurify backup config");
                fe.printStackTrace();
            }
        }
    }

    public void dump() {
        Structurify.getLogger().info("Dumping Structurify config...");
        try {
            if (Files.exists(this.configDumpPath, new LinkOption[0])) {
                Files.delete(this.configDumpPath);
            }
            JsonObject json = new JsonObject();
            json.addProperty(CONFIG_VERSION_PROPERTY, PlatformHooks.PLATFORM_HELPER.getModVersion());
            json.addProperty(CONFIG_DATETIME_PROPERTY, LocalDateTime.now().format(DATETIME_FORMATTER));
            this.saveGeneralData(json);
            this.saveStructuresData(json, false);
            this.saveStructureSetsData(json, false);
            Files.createDirectories(this.configDumpPath.getParent(), new FileAttribute[0]);
            Files.createFile(this.configDumpPath, new FileAttribute[0]);
            Files.writeString(this.configDumpPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
            Structurify.getLogger().info("Structurify config successfully dumped");
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to dump Structurify config");
            e.printStackTrace();
        }
    }

    private void saveGeneralData(JsonObject json) {
        JsonObject general = new JsonObject();
        general.addProperty(MIN_STRUCTURE_DISTANCE_FROM_WORLD_CENTER_PROPERTY, (Number)this.minStructureDistanceFromWorldCenter);
        general.addProperty(DISABLE_ALL_STRUCTURES_PROPERTY, Boolean.valueOf(this.disableAllStructures));
        general.addProperty(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY, Boolean.valueOf(this.enableGlobalSpacingAndSeparationModifier));
        general.addProperty(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY, (Number)((double)Math.round(this.globalSpacingAndSeparationModifier * 10.0) / 10.0));
        json.add(GENERAL_PROPERTY, (JsonElement)general);
    }

    private void saveStructuresData(JsonObject json, boolean saveOnlyChanged) {
        JsonArray structures = new JsonArray();
        this.structureData.entrySet().stream().filter(entry -> !saveOnlyChanged || !((StructureData)entry.getValue()).isUsingDefaultValues()).forEach(structureDataEntry -> {
            JsonObject structure = new JsonObject();
            structure.addProperty(NAME_PROPERTY, (String)structureDataEntry.getKey());
            structure.addProperty(IS_DISABLED_PROPERTY, Boolean.valueOf(((StructureData)structureDataEntry.getValue()).isDisabled()));
            structure.addProperty(ENABLE_FLATNESS_CHECK_PROPERTY, Boolean.valueOf(((StructureData)structureDataEntry.getValue()).isFlatnessCheckEnabled()));
            structure.addProperty(FLATNESS_CHECK_DISTANCE_PROPERTY, (Number)((StructureData)structureDataEntry.getValue()).getFlatnessCheckDistance());
            structure.addProperty(FLATNESS_CHECK_THRESHOLD_PROPERTY, (Number)((StructureData)structureDataEntry.getValue()).getFlatnessCheckThreshold());
            structure.addProperty(ENABLE_BIOME_CHECK_PROPERTY, Boolean.valueOf(((StructureData)structureDataEntry.getValue()).isBiomeCheckEnabled()));
            structure.addProperty(BIOME_CHECK_DISTANCE_PROPERTY, (Number)((StructureData)structureDataEntry.getValue()).getBiomeCheckDistance());
            structure.addProperty(BIOME_CHECK_MODE_PROPERTY, ((StructureData)structureDataEntry.getValue()).getBiomeCheckMode().name());
            ArrayList<String> biomeCheckBlacklistedBiomes = new ArrayList<String>(((StructureData)structureDataEntry.getValue()).getBiomeCheckBlacklistedBiomes());
            JsonArray biomeCheckBlacklistedBiomesJson = new JsonArray();
            biomeCheckBlacklistedBiomes.stream().distinct().forEach(arg_0 -> ((JsonArray)biomeCheckBlacklistedBiomesJson).add(arg_0));
            structure.add(BIOME_CHECK_BLACKLISTED_BIOMES_PROPERTY, (JsonElement)biomeCheckBlacklistedBiomesJson);
            ArrayList<String> whitelistedBiomes = new ArrayList<String>(((StructureData)structureDataEntry.getValue()).getBiomes());
            whitelistedBiomes.removeAll(((StructureData)structureDataEntry.getValue()).getDefaultBiomes());
            JsonArray whitelistedBiomesJson = new JsonArray();
            whitelistedBiomes.stream().distinct().forEach(arg_0 -> ((JsonArray)whitelistedBiomesJson).add(arg_0));
            structure.add(WHITELISTED_BIOMES_PROPERTY, (JsonElement)whitelistedBiomesJson);
            ArrayList<String> blacklistedBiomes = new ArrayList<String>(((StructureData)structureDataEntry.getValue()).getDefaultBiomes());
            blacklistedBiomes.removeAll(((StructureData)structureDataEntry.getValue()).getBiomes());
            JsonArray blacklistedBiomesJson = new JsonArray();
            blacklistedBiomes.stream().distinct().forEach(arg_0 -> ((JsonArray)blacklistedBiomesJson).add(arg_0));
            structure.add(BLACKLISTED_BIOMES_PROPERTY, (JsonElement)blacklistedBiomesJson);
            structures.add((JsonElement)structure);
        });
        json.add(STRUCTURES_PROPERTY, (JsonElement)structures);
    }

    private void saveStructureSetsData(JsonObject json, boolean saveOnlyChanged) {
        JsonArray structureSets = new JsonArray();
        this.structureSetData.entrySet().stream().filter(entry -> !saveOnlyChanged || ((StructureSetData)entry.getValue()).isUsingDefaultValues()).forEach(structureSetDataEntry -> {
            StructureSetData structureSetData = (StructureSetData)structureSetDataEntry.getValue();
            String structureSetName = (String)structureSetDataEntry.getKey();
            boolean overrideGlobalSpacingAndSeparationModifier = structureSetData.overrideGlobalSpacingAndSeparationModifier();
            int salt = structureSetData.getSalt();
            float frequency = structureSetData.getFrequency();
            int spacing = structureSetData.getSpacing();
            int separation = structureSetData.getSeparation();
            if ((salt < 0 || salt > Integer.MAX_VALUE) && salt != structureSetData.getDefaultSalt()) {
                Structurify.getLogger().info("Salt value for structure set {} is currently {}, which is invalid, value will be automatically corrected to {}.", new Object[]{structureSetName, salt, structureSetData.getDefaultSalt()});
                salt = structureSetData.getDefaultSalt();
            }
            if (frequency < 0.0f || frequency > 1.0f) {
                Structurify.getLogger().info("Frequency value for structure set {} is currently {}, which is invalid, value will be automatically corrected to {}.", new Object[]{structureSetName, Float.valueOf(frequency), Float.valueOf(structureSetData.getDefaultFrequency())});
                frequency = structureSetData.getDefaultFrequency();
            }
            if (separation >= spacing) {
                Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is bigger than spacing {}, value will be automatically corrected to {}. ", new Object[]{structureSetName, separation, spacing, spacing - 1});
                separation = spacing - 1;
            }
            if (separation < 0) {
                Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)separation);
                separation = 0;
            }
            if (spacing < 1) {
                Structurify.getLogger().info("Spacing value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)spacing);
                separation = 0;
            }
            JsonObject specificStructureSpread = new JsonObject();
            specificStructureSpread.addProperty(NAME_PROPERTY, structureSetName);
            specificStructureSpread.addProperty(SALT_PROPERTY, (Number)salt);
            specificStructureSpread.addProperty(FREQUENCY_PROPERTY, (Number)Float.valueOf(frequency));
            specificStructureSpread.addProperty(OVERRIDE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY, Boolean.valueOf(overrideGlobalSpacingAndSeparationModifier));
            specificStructureSpread.addProperty(SPACING_PROPERTY, (Number)spacing);
            specificStructureSpread.addProperty(SEPARATION_PROPERTY, (Number)separation);
            structureSets.add((JsonElement)specificStructureSpread);
        });
        json.add(STRUCTURE_SETS_PROPERTY, (JsonElement)structureSets);
    }

    private Path getBackupConfigPath() {
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
        return Path.of(BACKUP_CONFIG_DIR.toString(), BACKUP_PREFIX + dateTime + ".json");
    }

    private Path getLatestBackupConfigPath() {
        try {
            if (!Files.exists(BACKUP_CONFIG_DIR, new LinkOption[0]) || !Files.isDirectory(BACKUP_CONFIG_DIR, new LinkOption[0])) {
                return null;
            }
            Optional<Path> latest = Files.list(BACKUP_CONFIG_DIR).filter(path -> path.getFileName().toString().startsWith(BACKUP_PREFIX) && path.toString().endsWith(".json")).max(Comparator.comparing(path -> {
                String timestamp = path.getFileName().toString().replace(BACKUP_PREFIX, "").replace(".json", "");
                try {
                    return LocalDateTime.parse(timestamp, DATETIME_FORMATTER);
                }
                catch (Exception e) {
                    return LocalDateTime.MIN;
                }
            }));
            return latest.orElse(null);
        }
        catch (IOException e) {
            Structurify.getLogger().error("Failed to load Structurify backup configs");
            e.printStackTrace();
            return null;
        }
    }
}

