/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT}, modid="structures_tweaker")
public class StructureBoxRenderer {
    private static final Map<ResourceLocation, BoundingBox> boxes = new HashMap<ResourceLocation, BoundingBox>();
    private static boolean isEnabled = false;
    private static final RenderType STRUCTURE_LINES = RenderType.create((String)"structure_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).createCompositeState(false));

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
        if (!enabled) {
            StructureBoxRenderer.clearBoxes();
        }
    }

    public static void addBox(ResourceLocation id, BoundingBox box) {
        boxes.put(id, box);
    }

    public static void clearBoxes() {
        boxes.clear();
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!isEnabled || !event.getLevel().isClientSide()) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        chunk.getAllStarts().forEach((structure, structureStart) -> {
            if (structureStart != null) {
                structureStart.getBoundingBox();
                ResourceLocation id = event.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE).getKey(structure);
                if (id != null) {
                    boxes.put(id, structureStart.getBoundingBox());
                }
            }
        });
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (!isEnabled || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        boxes.forEach((id, box) -> {
            AABB aabb = new AABB((double)box.minX() - event.getCamera().getPosition().x, (double)box.minY() - event.getCamera().getPosition().y, (double)box.minZ() - event.getCamera().getPosition().z, (double)(box.maxX() + 1) - event.getCamera().getPosition().x, (double)(box.maxY() + 1) - event.getCamera().getPosition().y, (double)(box.maxZ() + 1) - event.getCamera().getPosition().z);
            RenderSystem.lineWidth((float)10.0f);
            VertexConsumer builder = buffer.getBuffer(STRUCTURE_LINES);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        });
        buffer.endBatch(STRUCTURE_LINES);
    }
}

