/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.properties;

import java.util.List;
import java.util.function.Function;

public class ConfigProperty<T> {
    private final String key;
    private final T defaultValue;
    private final Class<T> type;
    private final String description;
    private final Function<Object, T> converter;

    public ConfigProperty(String key, T defaultValue, Class<T> type, String description) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.description = description;
        this.converter = this.createConverter(type);
    }

    private Function<Object, T> createConverter(Class<T> type) {
        if (type == Boolean.class) {
            return obj -> {
                if (obj instanceof Boolean) {
                    return obj;
                }
                if (obj instanceof String) {
                    return Boolean.valueOf((String)obj);
                }
                return this.defaultValue;
            };
        }
        if (type == Integer.class) {
            return obj -> {
                if (obj instanceof Number) {
                    return ((Number)obj).intValue();
                }
                if (obj instanceof String) {
                    return Integer.valueOf((String)obj);
                }
                return this.defaultValue;
            };
        }
        if (type == String.class) {
            return obj -> String.valueOf(obj);
        }
        if (type == List.class) {
            return obj -> {
                if (obj instanceof List) {
                    return obj;
                }
                return this.defaultValue;
            };
        }
        return obj -> obj;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public T convert(Object value) {
        return this.converter.apply(value);
    }
}

