/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.command;

import com.leclowndu93150.structures_tweaker.data.EmptyChunksData;
import com.leclowndu93150.structures_tweaker.render.StructureBoxRenderer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@OnlyIn(value=Dist.CLIENT)
public class ShowStructureCommand {
    private static boolean isEnabled = false;
    private static long lastCheckTime = 0L;
    private static final long CHECK_INTERVAL = 20L;

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
        StructureBoxRenderer.setEnabled(enabled);
        if (!enabled) {
            StructureBoxRenderer.clearBoxes();
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (!isEnabled) {
            return;
        }
        long currentTime = event.getServer().getTickCount();
        if (currentTime - lastCheckTime >= 20L) {
            lastCheckTime = currentTime;
            List player = event.getServer().getPlayerList().getPlayers();
            for (ServerPlayer p : player) {
                ShowStructureCommand.checkStructures(p.createCommandSourceStack());
            }
        }
    }

    public static int checkStructures(CommandSourceStack source) {
        ServerLevel serverLevel = source.getLevel();
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        AtomicBoolean found = new AtomicBoolean(false);
        ChunkPos centerChunk = new ChunkPos(pos);
        EmptyChunksData emptyChunksData = EmptyChunksData.get(serverLevel);
        int searchRadius = 2;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                ChunkPos checkChunk = new ChunkPos(centerChunk.x + x, centerChunk.z + z);
                if (emptyChunksData.isEmpty(checkChunk)) continue;
                LevelChunk chunk = serverLevel.getChunk(checkChunk.x, checkChunk.z);
                boolean structureFound = false;
                chunk.getAllStarts().forEach((structure, structureStart) -> {
                    if (structureStart != null) {
                        structureStart.getBoundingBox();
                        ResourceLocation id = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey(structure);
                        if (id != null) {
                            found.set(true);
                            BoundingBox box = structureStart.getBoundingBox();
                            StructureBoxRenderer.addBox(id, box);
                        }
                    }
                });
                if (structureFound) continue;
                emptyChunksData.markEmpty(checkChunk);
            }
        }
        return 1;
    }
}

