/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.statuseffectbars.render;

import com.leclowndu93150.statuseffectbars.config.Direction;
import com.leclowndu93150.statuseffectbars.config.StatusEffectBarsConfig;
import com.leclowndu93150.statuseffectbars.duck.StatusEffectInstanceDuck;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;

public class StatusEffectBarRenderer {
    public static void render(GuiGraphics context, @Nullable DeltaTracker tickCounter, MobEffectInstance effect, int x, int y, int width, int height, StatusEffectBarsConfig.LayoutConfig layoutConfig) {
        if (!((Boolean)layoutConfig.enabled.get()).booleanValue()) {
            return;
        }
        if (effect.getDuration() > (Integer)StatusEffectBarsConfig.INSTANCE.maxRemainingDuration.get() || effect.isInfiniteDuration()) {
            return;
        }
        StatusEffectInstanceDuck duck = (StatusEffectInstanceDuck)effect;
        int age = duck.statusEffectBars_getMaxDuration() - effect.getDuration();
        if (effect.isAmbient() && age < (Integer)StatusEffectBarsConfig.INSTANCE.minAmbientAge.get()) {
            return;
        }
        if (((Direction)((Object)layoutConfig.direction.get())).swapXY) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        int startX = (Integer)layoutConfig.collinearOffset.get() + (Integer)layoutConfig.collinearPadding.get();
        int endX = (Integer)layoutConfig.collinearOffset.get() + width - (Integer)layoutConfig.collinearPadding.get();
        if (((Direction)((Object)layoutConfig.direction.get())).reverseAxis) {
            int tmp = startX;
            startX = endX;
            endX = tmp;
        }
        float tickDelta = tickCounter != null ? tickCounter.getGameTimeDeltaPartialTick(false) : 0.0f;
        float progress = ((float)effect.getDuration() - tickDelta) / (float)((StatusEffectInstanceDuck)effect).statusEffectBars_getMaxDuration();
        int middleX = (int)Mth.lerp((float)progress, (float)startX, (float)endX);
        int startY = (Integer)layoutConfig.orthogonalOffset.get();
        if (((Boolean)layoutConfig.relativeToEnd.get()).booleanValue()) {
            startY = height - (startY + (Integer)layoutConfig.thickness.get());
        }
        int middleY = startY + (Integer)layoutConfig.thickness.get();
        int endY = startY;
        if (((Direction)((Object)layoutConfig.direction.get())).swapXY) {
            int tmp = startX;
            startX = startY;
            startY = tmp;
            tmp = middleX;
            middleX = middleY;
            middleY = tmp;
            tmp = endX;
            endX = endY;
            endY = tmp;
        }
        context.fill(startX += x, startY += y, middleX += x, middleY += y, StatusEffectBarsConfig.INSTANCE.getColor(effect));
        context.fill(middleX, middleY, endX += x, endY += y, ((Integer)StatusEffectBarsConfig.INSTANCE.backgroundColor.get()).intValue());
    }
}

