/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.power.NetherGemPower;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class NullificationPower
extends NetherGemPower {
    public NullificationPower() {
        super(false);
    }

    @Override
    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        BlockState state;
        ServerLevel serverWorld;
        BlockState currentState;
        if (!attacker.hasEffect(EffectRegistry.getReference(EffectRegistry.BATTLE_FATIGUE)) && !attacker.level().isClientSide() && (currentState = (serverWorld = (ServerLevel)attacker.level()).getBlockState(attacker.blockPosition().above(4).relative(attacker.getMotionDirection(), 3))) == (state = Blocks.AIR.defaultBlockState())) {
            serverWorld.playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), attacker.getSoundSource(), 0.4f, 0.8f);
            BattleStandardEntity banner = (BattleStandardEntity)((EntityType)EntityRegistry.BATTLESTANDARD.get()).spawn(serverWorld, attacker.blockPosition().above(4).relative(attacker.getMotionDirection(), 3), MobSpawnType.MOB_SUMMONED);
            if (banner != null) {
                banner.setDeltaMovement(0.0, -1.0, 0.0);
                banner.ownerEntity = attacker;
                banner.decayRate = 3;
                banner.standardType = "nullification";
                banner.setCustomName((Component)Component.translatable((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{attacker.getName()}));
            }
            attacker.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.BATTLE_FATIGUE), 800, 0), (Entity)attacker);
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification").setStyle(Styles.NETHERFUSED));
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description2")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description3")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description4")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description5")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
        }
    }
}

