/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.MoltenParticleComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class MoltenEdgeSwordItem
extends UniqueSwordItem {
    public MoltenEdgeSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.level().isClientSide()) {
            return super.hurtEnemy(stack, target, attacker);
        }
        int proc_chance = Config.uniqueEffects.molten_edge.chance;
        ServerLevel world = (ServerLevel)attacker.level();
        HelperMethods.playHitSounds(attacker, target);
        if (attacker.getRandom().nextInt(100) <= proc_chance) {
            world.playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), attacker.getSoundSource(), 0.6f, 2.0f);
            if (attacker.getRandom().nextInt(100) <= 50) {
                if (attacker.getHealth() > 2.0f) {
                    attacker.igniteForSeconds(3.0f);
                }
                if (attacker.getHealth() < 4.0f) {
                    attacker.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 3), (Entity)attacker);
                }
            } else if (attacker.getRandom().nextInt(100) > 50) {
                target.igniteForSeconds(3.0f);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.level().isClientSide()) {
            return super.use(world, user, hand);
        }
        double radius = Config.uniqueEffects.molten_edge.radius;
        double knockbackStrength = Config.uniqueEffects.molten_edge.knockbackStrength;
        int abilityCooldown = Config.uniqueEffects.molten_edge.cooldown;
        int amp = 0;
        AABB box = new AABB(user.getX() + radius, user.getY() + radius, user.getZ() + radius, user.getX() - radius, user.getY() - radius, user.getZ() - radius);
        for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
            LivingEntity le;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user)) continue;
            ++amp;
            le.setDeltaMovement((le.getX() - user.getX()) / knockbackStrength, 0.6, (le.getZ() - user.getZ()) / knockbackStrength);
            le.igniteForSeconds(3.0f);
        }
        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.getSoundSource(), 0.7f, 1.5f);
        int duration = Config.uniqueEffects.molten_edge.duration * amp / 2;
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.ONSLAUGHT), duration, 0), (Entity)user);
        user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration, 3), (Entity)user);
        user.getCooldowns().addCooldown((Item)this, abilityCooldown);
        ItemStack stack = user.getItemInHand(hand);
        stack.set((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((ParticleOptions)ParticleTypes.LAVA, (ParticleOptions)ParticleTypes.LAVA, (ParticleOptions)ParticleTypes.LARGE_SMOKE));
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (!world.isClientSide && entity instanceof Player && (player = (Player)entity).getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
            int amp = 0;
            if (player.tickCount % 40 == 0) {
                if (player.getHealth() < player.getMaxHealth() / 2.0f && player.getHealth() > player.getMaxHealth() / 3.0f) {
                    amp = 1;
                    stack.set((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.LARGE_SMOKE));
                } else if (player.getHealth() < player.getMaxHealth() / 3.0f && player.getHealth() > 2.0f) {
                    amp = 2;
                    stack.set((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.LARGE_SMOKE));
                } else if (player.getHealth() <= 2.0f) {
                    amp = 3;
                    stack.set((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((ParticleOptions)ParticleTypes.LAVA, (ParticleOptions)ParticleTypes.LAVA, (ParticleOptions)ParticleTypes.LARGE_SMOKE));
                } else {
                    stack.set((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)MoltenParticleComponent.DEFAULT);
                }
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, amp), (Entity)player);
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, amp - 1), (Entity)player);
            }
        }
        MoltenParticleComponent component = (MoltenParticleComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)MoltenParticleComponent.DEFAULT);
        HelperMethods.createFootfalls(entity, stack, world, component.walk(), component.sprint(), component.passive(), true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.moltenedgesworditem.tooltip7").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public double knockbackStrength;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.MOLTEN_EDGE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 15;
            this.cooldown = 320;
            this.duration = 100;
            this.knockbackStrength = 5.0;
            this.radius = 5.0;
        }
    }
}

