/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.List;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.SimplySwords;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.client.api.SimplySwordsClientAPI;
import net.sweenus.simplyswords.power.GemPower;
import net.sweenus.simplyswords.power.GemPowerComponent;
import net.sweenus.simplyswords.power.GemPowerFiller;
import net.sweenus.simplyswords.power.PowerType;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.Styles;

public class RunefusedGemItem
extends Item
implements GemPowerFiller {
    public RunefusedGemItem() {
        super(new Item.Properties().arch$tab(SimplySwords.SIMPLYSWORDS).rarity(Rarity.EPIC).fireResistant().stacksTo(1));
    }

    @Override
    public ValidationResult<GemPowerComponent> fill(ItemStack stack, GemPowerComponent component) {
        GemPowerComponent gemComponent = SimplySwordsAPI.getComponent(stack);
        if (!(gemComponent.hasRunicPower() && ((GemPower)component.runicPower().value()).isEmpty() && component.hasRunicPower())) {
            return ValidationResult.Companion.error((Object)component, "Can't socket to the provided component");
        }
        return ValidationResult.Companion.success((Object)component.fill((Boolean hasRunic, Holder<GemPower> oldRunic) -> gemComponent.runicPower(), (Boolean hasNether, Holder<GemPower> oldNether) -> oldNether));
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (!stack.has((DataComponentType)ComponentTypeRegistry.GEM_POWER.get())) {
            stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNEFUSED)));
        }
        return false;
    }

    public void onCraftedPostProcess(ItemStack stack, Level world) {
        if (world.isClientSide) {
            return;
        }
        if (!stack.has((DataComponentType)ComponentTypeRegistry.GEM_POWER.get())) {
            stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNEFUSED)));
        }
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.RUNIC);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        GemPowerComponent component = SimplySwordsAPI.getComponent(itemStack);
        if (component.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.unidentifiedsworditem.tooltip1").setStyle(Styles.RUNIC));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.unidentifiedsworditem.tooltip2").setStyle(Styles.TEXT));
        } else {
            component.appendTooltip(itemStack, tooltipContext, tooltip, type);
        }
        tooltip.add((Component)Component.literal((String)""));
        this.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type);
        if (Screen.hasAltDown()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.gem_description").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.gem_description2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    protected void generateDynamicTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        SimplySwordsClientAPI.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type, "simplyswords", "oracle_index:books/simplyswords/weapon-types", "oracle_index:books/simplyswords/unique-weapons", "oracle_index:books/simplyswords/runic-powers", null);
    }
}

