/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.client.renderer.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ShoulderAxolotlFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation WILD_AXOLOTL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/axolotl/axolotl_wild.png");
    private static final ResourceLocation LUCY_AXOLOTL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/axolotl/axolotl_lucy.png");
    private static final ResourceLocation GOLD_AXOLOTL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/axolotl/axolotl_gold.png");
    private static final ResourceLocation CYAN_AXOLOTL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/axolotl/axolotl_cyan.png");
    private static final ResourceLocation BLUE_AXOLOTL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/axolotl/axolotl_blue.png");
    private final ModelPart axolotlModel;

    public ShoulderAxolotlFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context, ModelPart axolotlModel) {
        super(context);
        this.axolotlModel = axolotlModel;
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture;
        if (!player.getShoulderEntityLeft().isEmpty() && "simplyswords:simplyaxolotlentity".equals(player.getShoulderEntityLeft().getString("id"))) {
            matrixStack.pushPose();
            this.attachToShoulder(matrixStack, true, player, tickDelta);
            texture = this.getAxolotlTexture(player.getShoulderEntityLeft());
            this.renderAxolotl(matrixStack, vertexConsumerProvider, light, texture);
            matrixStack.popPose();
        }
        if (!player.getShoulderEntityRight().isEmpty() && "simplyswords:simplyaxolotlentity".equals(player.getShoulderEntityRight().getString("id"))) {
            matrixStack.pushPose();
            this.attachToShoulder(matrixStack, false, player, tickDelta);
            texture = this.getAxolotlTexture(player.getShoulderEntityRight());
            this.renderAxolotl(matrixStack, vertexConsumerProvider, light, texture);
            matrixStack.popPose();
        }
    }

    private void renderAxolotl(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, ResourceLocation texture) {
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        this.axolotlModel.render(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }

    private void attachToShoulder(PoseStack matrixStack, boolean leftShoulder, AbstractClientPlayer player, float tickDelta) {
        int direction = leftShoulder ? -1 : 1;
        float interpolatedBodyYaw = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * tickDelta;
        float bodyYawRadians = interpolatedBodyYaw % 360.0f * ((float)Math.PI / 180);
        matrixStack.translate((float)direction * 0.4f, player.isCrouching() ? -0.1f : -0.4f, 0.15f);
        matrixStack.translate(0.0f, -1.0f, -0.2f);
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotation(bodyYawRadians));
        matrixStack.translate((float)direction * 0.4f, player.isCrouching() ? -0.1f : 0.0f, 0.15f);
        matrixStack.translate(0.0f, -1.0f, -0.2f);
        matrixStack.popPose();
    }

    private ResourceLocation getAxolotlTexture(CompoundTag nbt) {
        int variant = nbt.contains("Variant") ? nbt.getInt("Variant") : 0;
        return switch (variant) {
            case 0 -> LUCY_AXOLOTL_TEXTURE;
            case 1 -> WILD_AXOLOTL_TEXTURE;
            case 2 -> GOLD_AXOLOTL_TEXTURE;
            case 3 -> CYAN_AXOLOTL_TEXTURE;
            case 4 -> BLUE_AXOLOTL_TEXTURE;
            default -> WILD_AXOLOTL_TEXTURE;
        };
    }
}

