/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RenderTomb
implements BlockEntityRenderer<BlockEntityTomb> {
    private static final ResourceLocation SKELETON_HEAD = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
    private final Font font;
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    public RenderTomb(BlockEntityRendererProvider.Context cx) {
        this.font = cx.getFont();
    }

    public void render(BlockEntityTomb te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int destroyStage) {
        int rotationIndex;
        float value;
        if (te == null) {
            return;
        }
        if (!te.hasOwner()) {
            return;
        }
        BlockState knownState = te.getLevel().getBlockState(te.getBlockPos());
        Block block = knownState.getBlock();
        if (!(block instanceof BlockTomb)) {
            return;
        }
        BlockTomb grave = (BlockTomb)block;
        Direction facing = (Direction)knownState.getValue(BlockTomb.FACING);
        ModelTomb graveModel = grave.getGraveType();
        this.renderHalloween(poseStack, bufferSource, graveModel, facing, light, WorldHelper.isNight(te.getLevel()));
        light = 0xF000F0;
        float modX = 0.5f;
        float modZ = 0.5f;
        float modY = switch (graveModel) {
            case ModelTomb.GRAVE_CROSS -> {
                value = 0.25f;
                yield 0.06375f;
            }
            case ModelTomb.GRAVE_NORMAL -> {
                value = 0.12625f;
                yield 0.5f;
            }
            default -> {
                value = 0.18875f;
                yield 0.4f;
            }
        };
        boolean isCross = graveModel == ModelTomb.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (isCross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (isCross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (isCross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = isCross ? value : 1.0f - value;
            }
        }
        poseStack.pushPose();
        poseStack.translate(modX, modY, modZ);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (isCross) {
            switch (facing) {
                case SOUTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case WEST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    break;
                }
                default: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
            }
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f * (float)rotationIndex));
        Font fontRender = this.font;
        int textColor = -1;
        this.showString(String.valueOf(ChatFormatting.BOLD) + MessageType.MESSAGE_RIP.getTranslation(new Object[0]), poseStack, bufferSource, fontRender, 0, textColor, 0.007f, light);
        this.showString(String.valueOf(ChatFormatting.BOLD) + te.getOwnerName(), poseStack, bufferSource, fontRender, 11, textColor, 0.005f, light);
        float scaleForDate = 0.004f;
        long days = te.timer / 24000;
        String dateString = MessageType.MESSAGE_DAY.getTranslation(days);
        this.showString(String.valueOf(ChatFormatting.BOLD) + dateString, poseStack, bufferSource, fontRender, 20, textColor, scaleForDate, light);
        Date date = new Date(te.getOwnerDeathTime());
        String fdateString = new SimpleDateFormat(DATE_FORMAT).format(date);
        String timeString = new SimpleDateFormat(TIME_FORMAT).format(date);
        this.showString(String.valueOf(ChatFormatting.BOLD) + fdateString, poseStack, bufferSource, fontRender, 36, textColor, scaleForDate, light);
        this.showString(String.valueOf(ChatFormatting.BOLD) + timeString, poseStack, bufferSource, fontRender, 46, textColor, scaleForDate, light);
        poseStack.popPose();
    }

    private void showString(String content, PoseStack poseStack, MultiBufferSource bufferSource, Font font, int posY, int color, float scale, int light) {
        poseStack.pushPose();
        poseStack.scale(scale, scale, scale);
        font.drawInBatch(content, (float)(-font.width(content)) / 2.0f, (float)(posY - 30), color, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
        poseStack.popPose();
    }

    private void renderHalloween(PoseStack poseStack, MultiBufferSource bufferSource, ModelTomb graveModel, Direction facing, int light, boolean isNight) {
        RenderSystem.disableCull();
        float decoX = 0.5f;
        float decoY = 0.07f;
        float decoZ = 0.5f;
        switch (graveModel) {
            case GRAVE_NORMAL: {
                decoY += 0.35f;
                break;
            }
            case GRAVE_CROSS: {
                if (facing == Direction.SOUTH) {
                    decoX -= 0.2f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoZ -= 0.2f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoZ += 0.2f;
                    break;
                }
                decoX += 0.2f;
                break;
            }
            default: {
                decoY += 0.1f;
            }
        }
        Minecraft.getInstance().getTextureManager().bindForSetup(SKELETON_HEAD);
        poseStack.pushPose();
        poseStack.translate(decoX, decoY, decoZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot() + (float)(facing == Direction.SOUTH || facing == Direction.NORTH ? 180 : 0)));
        if (graveModel == ModelTomb.GRAVE_NORMAL || graveModel == ModelTomb.GRAVE_SIMPLE) {
            poseStack.scale(0.2f, 0.2f, 0.2f);
            ItemStack stack = new ItemStack((ItemLike)(isNight ? Blocks.JACK_O_LANTERN : Blocks.PUMPKIN));
            Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.NONE, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, 0));
        } else {
            poseStack.scale(0.3f, 0.3f, 0.3f);
        }
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(BlockEntityTomb blockEntity) {
        double renderExtension = 1.0;
        return new AABB((double)blockEntity.getBlockPos().getX() - renderExtension, (double)blockEntity.getBlockPos().getY() - renderExtension, (double)blockEntity.getBlockPos().getZ() - renderExtension, (double)(blockEntity.getBlockPos().getX() + 1) + renderExtension, (double)(blockEntity.getBlockPos().getY() + 1) + renderExtension, (double)(blockEntity.getBlockPos().getZ() + 1) + renderExtension);
    }
}

