/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.network;

import com.schematicenergistics.network.payloads.CannonInterfaceConfigClientPacket;
import com.schematicenergistics.network.payloads.CannonInterfaceConfigPacket;
import com.schematicenergistics.network.payloads.CannonInterfaceSyncPacket;
import com.schematicenergistics.network.payloads.CannonStatePacket;
import com.schematicenergistics.network.payloads.OpenCannonInterfacePacket;
import com.schematicenergistics.network.payloads.ReturnToTerminalPacket;
import com.schematicenergistics.network.payloads.TerminalListClientPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    private static final String PROTOCOL = "1";

    private PacketHandler() {
    }

    public static void init(IEventBus bus) {
        bus.addListener(PacketHandler::handlePacketRegistration);
    }

    private static void handlePacketRegistration(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL);
        registrar.playToClient(CannonInterfaceSyncPacket.TYPE, CannonInterfaceSyncPacket.STREAM_CODEC, PacketHandler.handler(CannonInterfaceSyncPacket::handle));
        registrar.playToServer(CannonInterfaceConfigPacket.TYPE, CannonInterfaceConfigPacket.STREAM_CODEC, PacketHandler.handler(CannonInterfaceConfigPacket::handle));
        registrar.playToClient(CannonInterfaceConfigClientPacket.TYPE, CannonInterfaceConfigClientPacket.STREAM_CODEC, PacketHandler.handler(CannonInterfaceConfigClientPacket::handle));
        registrar.playToServer(CannonStatePacket.TYPE, CannonStatePacket.STREAM_CODEC, PacketHandler.handler(CannonStatePacket::handle));
        registrar.playToClient(TerminalListClientPacket.TYPE, TerminalListClientPacket.STREAM_CODEC, PacketHandler.handler(TerminalListClientPacket::handle));
        registrar.playToServer(OpenCannonInterfacePacket.TYPE, OpenCannonInterfacePacket.STREAM_CODEC, PacketHandler.handler(OpenCannonInterfacePacket::handle));
        registrar.playToServer(ReturnToTerminalPacket.TYPE, ReturnToTerminalPacket.STREAM_CODEC, PacketHandler.handler(ReturnToTerminalPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> handler(IPayloadHandler<T> handler) {
        return (payload, context) -> context.enqueueWork(() -> handler.handle(payload, context));
    }
}

