/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.container;

import com.buuz135.refinedstoragerequestify.RSRContent;
import com.buuz135.refinedstoragerequestify.block.tile.RequesterBlockEntity;
import com.buuz135.refinedstoragerequestify.container.RequesterData;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RequesterContainer
extends AbstractResourceContainerMenu
implements ExportingIndicatorListener {
    private static final int EXPORT_CONFIG_SLOT_X = 8;
    private static final int EXPORT_CONFIG_SLOT_Y = 20;
    private final ExportingIndicators indicators;
    private final Predicate<Player> stillValid;

    public RequesterContainer(int syncId, Player player, RequesterBlockEntity blockEntity, ResourceContainer exportConfig, UpgradeContainer upgradeContainer, ExportingIndicators indicators) {
        super((MenuType)RSRContent.Menus.REQUESTER.get(), syncId, player);
        this.addSlots(player, exportConfig, upgradeContainer);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((RequesterBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((RequesterBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.indicators = indicators;
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    public RequesterContainer(int syncId, Inventory playerInventory, RequesterData interfaceData) {
        super((MenuType)RSRContent.Menus.REQUESTER.get(), syncId);
        ResourceContainer filterContainer = RequesterBlockEntity.createFilterContainer(interfaceData);
        this.addSlots(playerInventory.player, filterContainer, new UpgradeContainer(RSRContent.REQUESTER_DESTINATION, 4));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FUZZY_MODE, (Object)false));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.indicators = new ExportingIndicators(interfaceData.exportingIndicators());
        this.stillValid = p -> true;
    }

    private static int getExportSlotX(int index) {
        return 8 + 18 * index;
    }

    private void addSlots(Player player, ResourceContainer exportConfig, UpgradeContainer upgradeContainer) {
        for (int i = 0; i < exportConfig.size(); ++i) {
            this.addSlot(this.createExportConfigSlot(exportConfig, i));
        }
        this.addSlot((Slot)new UpgradeSlot(upgradeContainer, 0, 187, 6));
        this.addSlot((Slot)new UpgradeSlot(upgradeContainer, 1, 187, 24));
        this.addSlot((Slot)new UpgradeSlot(upgradeContainer, 2, 187, 42));
        this.addSlot((Slot)new UpgradeSlot(upgradeContainer, 3, 187, 60));
        this.addPlayerInventory(player.getInventory(), 8, 55);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createExportConfigSlot(ResourceContainer exportConfig, int index) {
        int x = RequesterContainer.getExportSlotX(index);
        return new ResourceSlot(exportConfig, index, (Component)Component.translatable((String)"block.rsrequestify.requester.tooltip.filter"), x, 20, ResourceSlotType.FILTER_WITH_AMOUNT);
    }

    public ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    public int getIndicators() {
        return this.indicators.size();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }
}

