/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.handler.TrainerHandler;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;

public class TrainerScreen
extends AbstractContainerScreen<TrainerHandler> {
    private boolean colorblindMode = (Boolean)Config.trainer_cb.get();
    private static final ResourceLocation GUI = ChickenRoostMod.ownresource("textures/screens/trainer.png");
    private static final ResourceLocation ARROW = ChickenRoostMod.ownresource("textures/screens/newarrow.png");
    private static final ResourceLocation ARROW_VANILLA = ChickenRoostMod.ownresource("textures/screens/arrow.png");
    private static final ResourceLocation GUI_VANILLA = ChickenRoostMod.ownresource("textures/screens/trainervanilla.png");
    private static final ResourceLocation ARROWBACK_VANILLA = ChickenRoostMod.ownresource("textures/screens/arrowback.png");

    public TrainerScreen(TrainerHandler menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int x = this.leftPos;
        int y = this.topPos - 17;
        Button b = Button.builder((Component)Component.literal((String)"V"), button -> {
            if (this.colorblindMode) {
                Config.trainer_cb.set((Object)false);
                Config.trainer_cb.save();
            } else {
                Config.trainer_cb.set((Object)true);
                Config.trainer_cb.save();
            }
        }).pos(this.leftPos, this.topPos - 17).size(13, 13).build();
        b.setTooltip(Tooltip.create((Component)Component.literal((String)"Vanilla Mode Switch")));
        this.addRenderableWidget((GuiEventListener)b);
    }

    private int getScaledProgress() {
        boolean colorblindMode = (Boolean)Config.trainer_cb.get();
        int arrowWidth = colorblindMode ? 40 : 54;
        return ((TrainerHandler)this.menu).getScaledProgress(arrowWidth);
    }

    protected void renderBg(@NotNull GuiGraphics ms, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.colorblindMode) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_VANILLA);
            ms.blit(GUI_VANILLA, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            ms.blit(ARROWBACK_VANILLA, this.leftPos + 57, this.topPos + 40, 0.0f, 0.0f, 40, 10, 40, 10);
            ms.blit(ARROW_VANILLA, this.leftPos + 57, this.topPos + 40, 0.0f, 0.0f, this.getScaledProgress(), 10, 40, 10);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
            ms.blit(GUI, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            ms.blit(ARROW, this.leftPos + 54, this.topPos + 31, 0.0f, 0.0f, this.getScaledProgress(), 33, 54, 33);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        this.colorblindMode = (Boolean)Config.trainer_cb.get();
    }

    public void render(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderTooltip(ms, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

