/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableHolder;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public abstract class LayoutTemplate
implements VariableHolder {
    private String type;
    private String id;
    private Component title;
    private List<ElementTemplate<?>> elements;
    private ElementCallback back;
    @SerializedName(value="refresh_rate")
    private int refreshRate;
    @SerializedName(value="on_refresh")
    private ElementCallback onRefresh;
    @SerializedName(value="on_open")
    private ElementCallback onOpen;
    private Map<String, Object> variables;

    public LayoutTemplate(String type, String id, Component title, List<ElementTemplate<?>> elements) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.elements = elements;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public List<ElementTemplate<?>> getElements() {
        return this.elements;
    }

    public ElementCallback getBack() {
        return this.back;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public final Screen createScreen(@Nullable VariableStorage storage) {
        return this.createScreen0(storage);
    }

    public void onOpen(TemplateScreen template, @Nullable VariableStorage storage) {
        if (this.onOpen != null) {
            this.onOpen.onPress(template, null, storage);
        }
    }

    public boolean onRefresh(TemplateScreen template, @Nullable VariableStorage storage) {
        if (this.onRefresh != null) {
            this.onRefresh.onPress(template, null, storage);
            return true;
        }
        return false;
    }

    protected abstract Screen createScreen0(@Nullable VariableStorage var1);
}

