/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.button.type;

import com.google.gson.annotations.SerializedName;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.button.type.SimpleButtonTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class ToggleButtonTemplate
extends SimpleButtonTemplate {
    private transient boolean toggled;
    @SerializedName(value="toggle_on_callback")
    private ElementCallback toggleOnCallback;
    @SerializedName(value="toggle_off_callback")
    private ElementCallback toggleOffCallback;

    public ToggleButtonTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    @Override
    protected SimpleTextButton createButton(final TemplateScreen screen, VariableStorage variableStorage, final boolean hasText) {
        return new SimpleTextButton(screen.getPanel(), (Component)(hasText ? this.getText() : Component.empty()), (Icon)(this.getIcon() == null ? Icon.empty() : Icon.getIcon((String)this.getIcon()))){

            public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                if (hasText) {
                    super.draw(graphics, theme, x, y, w, h);
                    return;
                }
                GuiHelper.setupDrawing();
                int sizeX = w - 6;
                int sizeY = h - 6;
                this.drawBackground(graphics, theme, x, y, w, h);
                this.drawIcon(graphics, theme, x + (w - sizeX) / 2, y + (h - sizeY) / 2, sizeX, sizeY);
            }

            public void onClicked(MouseButton button) {
                if (ToggleButtonTemplate.this.toggled) {
                    CallbackHolder.runCallbacks(screen, ToggleButtonTemplate.this, ToggleButtonTemplate.this.toggleOffCallback);
                } else {
                    CallbackHolder.runCallbacks(screen, ToggleButtonTemplate.this, ToggleButtonTemplate.this.toggleOnCallback);
                }
                ToggleButtonTemplate.this.toggled = !ToggleButtonTemplate.this.toggled;
                this.playClickSound();
            }

            public boolean renderTitleInCenter() {
                return ToggleButtonTemplate.this.isTextCentered();
            }

            public WidgetType getWidgetType() {
                String requiredVariable = ToggleButtonTemplate.this.getRequiredVariable();
                if (requiredVariable == null) {
                    return super.getWidgetType();
                }
                return screen.getStorage().contains(requiredVariable) ? super.getWidgetType() : WidgetType.DISABLED;
            }
        };
    }
}

