/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class OpenLinkCallback
extends ElementCallback {
    private Component title;
    private String link;
    @SerializedName(value="skip_confirmation")
    private boolean skipConfirmation = false;

    public OpenLinkCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        String link = VariableProcessor.process(this.link, variableStorage);
        if (!this.skipConfirmation) {
            Screen currentScreen = Minecraft.getInstance().screen;
            BooleanConsumer callback = result -> {
                if (result) {
                    try {
                        Util.getPlatform().openUri(link);
                    }
                    catch (Exception e) {
                        RocketClientMod.getLogger().error("An error occurred opening link", (Throwable)e);
                    }
                }
                Minecraft.getInstance().setScreen(currentScreen);
            };
            if (this.title != null) {
                Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(callback, this.title, link, true));
            } else {
                Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(callback, link, true));
            }
        } else {
            Util.getPlatform().openUri(link);
        }
    }
}

