/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.monitor.data.PowerMonitorData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PowerMonitorTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    @Cap(type=CapType.CONTAINER)
    private static final Function<PowerMonitorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Power Monitor").containerSupplier(DefaultContainerProvider.empty(MonitorModule.CONTAINER_POWER_MONITOR, (GenericTileEntity)be)).data(MonitorModule.POWER_MONITOR_DATA, PowerMonitorData.STREAM_CODEC, PowerMonitorData.CODEC).setupSync((GenericTileEntity)be);
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)5);
    private boolean inAlarm = false;
    private int counter = 20;

    public PowerMonitorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MonitorModule.POWER_MONITOR.be().get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:powermonitor/powermonitor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerMonitorTileEntity::new)){

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{LEVEL});
            }
        };
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getMinimum() {
        return ((PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA)).minimum();
    }

    public void setMinimum(int minimum) {
        PowerMonitorData data = (PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA);
        data = data.withMinimum((byte)minimum);
        this.setData(MonitorModule.POWER_MONITOR_DATA, data);
    }

    public int getMaximum() {
        return ((PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA)).maximum();
    }

    public void setMaximum(int maximum) {
        PowerMonitorData data = (PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA);
        data = data.withMaximum((byte)maximum);
        this.setData(MonitorModule.POWER_MONITOR_DATA, data);
    }

    public void setInvalid() {
        this.changeRfLevel(0);
        this.support.setRedstoneState((GenericTileEntity)this, 0);
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        Direction inputSide = LogicSupport.getFacing((BlockState)this.level.getBlockState(this.getBlockPos())).getInputSide();
        BlockPos inputPos = this.getBlockPos().relative(inputSide);
        BlockEntity tileEntity = this.level.getBlockEntity(inputPos);
        if (!EnergyTools.isEnergyTE((BlockEntity)tileEntity, null)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((BlockEntity)tileEntity, null);
        long maxEnergy = energy.maxEnergy();
        int ratio = 0;
        boolean alarm = false;
        PowerMonitorData data = (PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA);
        if (maxEnergy > 0L) {
            long stored = energy.energy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            long percentage = stored * 100L / maxEnergy;
            boolean bl = alarm = percentage >= (long)data.minimum() && percentage <= (long)data.maximum();
        }
        if (data.rflevel() != ratio) {
            this.changeRfLevel(ratio);
            this.setChanged();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.support.setRedstoneState((GenericTileEntity)this, this.inAlarm ? 15 : 0);
            this.setChanged();
        }
    }

    private void changeRfLevel(int newRfLevel) {
        PowerMonitorData data = (PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA);
        if (newRfLevel != data.rflevel()) {
            data = data.withRflevel(newRfLevel);
            this.setData(MonitorModule.POWER_MONITOR_DATA, data);
            this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)LEVEL, (Comparable)Integer.valueOf(data.rflevel())), 11);
        }
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.support.setPowerOutput(tagCompound.getBoolean("rs") ? 15 : 0);
        this.inAlarm = tagCompound.getBoolean("inAlarm");
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putBoolean("rs", this.support.getPowerOutput() > 0);
        tagCompound.putBoolean("inAlarm", this.inAlarm);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        PowerMonitorData data = (PowerMonitorData)input.get(MonitorModule.ITEM_POWER_MONITOR_DATA);
        if (data != null) {
            this.setData(MonitorModule.POWER_MONITOR_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        PowerMonitorData data = (PowerMonitorData)this.getData(MonitorModule.POWER_MONITOR_DATA);
        builder.set(MonitorModule.ITEM_POWER_MONITOR_DATA, (Object)data);
    }
}

