/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Tools;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.data.PowerCardData;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.util.Lazy;

public class PowerCellCardItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
        int id = PowerCellCardItem.getId(stack);
        if (id == -1) {
            return "<unlinked>";
        }
        return Integer.toString(id);
    })}));

    public PowerCellCardItem() {
        super(RFToolsPower.setup.defaultProperties());
    }

    public static void initOverrides(PowerCellCardItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rftoolspower", (String)"linked"), (stack, world, livingEntity, seed) -> {
            int id = PowerCellCardItem.getId(stack);
            return id == -1 ? 0.0f : 1.0f;
        });
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public static int getId(ItemStack stack) {
        return ((PowerCardData)stack.getOrDefault(DimensionalCellModule.ITEM_POWERCARD_DATA, (Object)PowerCardData.EMPTY)).id();
    }

    public static void setId(ItemStack stack, int id) {
        stack.set(DimensionalCellModule.ITEM_POWERCARD_DATA, (Object)new PowerCardData(id));
    }
}

