/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.modules.scanner.network.PacketRequestShapeData;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.BeaconType;
import mcjty.rftoolsbuilder.shapes.IShapeParentGui;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ScanDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import mcjty.rftoolsbuilder.shapes.ShapeBlockInfo;
import mcjty.rftoolsbuilder.shapes.ShapeDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ShapeRenderer {
    private int prevX = -1;
    private int prevY = -1;
    private float scale = 3.0f;
    private float dx = 230.0f;
    private float dy = 100.0f;
    private float xangle = 25.0f;
    private float yangle = 25.0f;
    private float zangle = 0.0f;
    private ShapeID shapeID;
    private int waitForNewRequest = 0;
    private static Vec3 offset = new Vec3(0.0, 0.0, 0.0);
    private int extraDataCounter = 0;
    private static RenderData.RenderElement[] beaconElement = null;
    private static RenderData.RenderElement[] beaconElementBeacon = null;

    public ShapeRenderer(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public void setShapeID(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public ShapeID getShapeID() {
        return this.shapeID;
    }

    public int getCount() {
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null) {
            return data.getBlockCount();
        }
        return 0;
    }

    public static RenderData getRenderDataAndCreate(ShapeID shapeID) {
        RenderData data = ShapeDataManagerClient.getRenderDataAndCreate(shapeID);
        data.touch();
        return data;
    }

    public static void setRenderData(ShapeID id, @Nullable RenderData.RenderPlane plane, int offsetY, int dy, String msg) {
        RenderData data = ShapeRenderer.getRenderDataAndCreate(id);
        data.setPlaneData(plane, offsetY, dy);
        data.previewMessage = msg;
    }

    public void initView(int dx, int dy) {
        Minecraft mc = Minecraft.getInstance();
        Window mainWindow = mc.getWindow();
        int xScale = mainWindow.getGuiScaledWidth();
        int yScale = mainWindow.getGuiScaledHeight();
        int sx = (dx + 84) * mainWindow.getScreenWidth() / xScale;
        int sy = mainWindow.getScreenHeight() - (dy + 136) * mainWindow.getScreenHeight() / yScale;
        int sw = 161 * mainWindow.getScreenWidth() / xScale;
        int sh = 130 * mainWindow.getScreenHeight() / yScale;
        int vx = sx + sw / 2;
        int vy = sy + sh / 2;
        this.dx = (float)((double)vx / mainWindow.getGuiScale());
        this.dy = (float)((double)vy / mainWindow.getGuiScale());
    }

    public void handleShapeDragging(int x, int y, boolean[] buttons) {
        MouseHandler mouse = Minecraft.getInstance().mouseHandler;
        if (x >= 100 && y <= 120) {
            if (SafeClientTools.isSneaking()) {
                if (this.prevX != -1 && buttons[0]) {
                    this.dx += (float)(x - this.prevX);
                    this.dy += (float)(y - this.prevY);
                }
            } else if (this.prevX != -1 && buttons[0]) {
                this.yangle -= (float)(x - this.prevX);
                this.xangle += (float)(y - this.prevY);
            }
            this.prevX = x;
            this.prevY = y;
        }
        if (buttons[2]) {
            this.xangle = 0.0f;
            this.yangle = 0.0f;
        }
    }

    public void handleMouseWheel(double dwheelX, double dwheelY) {
        float dwheel = (float)dwheelY;
        if (dwheel < 0.0f) {
            this.scale = (float)((double)this.scale * 0.6);
            if ((double)this.scale <= 0.1) {
                this.scale = 0.1f;
            }
        } else if (dwheel > 0.0f) {
            this.scale = (float)((double)this.scale * 1.4);
        }
    }

    public boolean renderShapeInWorld(ItemStack stack, double x, double y, double z, float offset, float scale, float angle, boolean scan, ShapeID shape) {
        return false;
    }

    public void renderShape(GuiGraphics graphics, IShapeParentGui gui, ItemStack stack, int x, int y, boolean showAxis, boolean showOuter, boolean showScan, boolean showGuidelines) {
        PoseStack matrixStack = graphics.pose();
        ShapeRenderer.setupScissor(gui);
        matrixStack.pushPose();
        matrixStack.translate(this.dx, this.dy, 200.0f);
        RenderHelper.rotateXP((PoseStack)matrixStack, (float)(180.0f - this.xangle));
        RenderHelper.rotateYP((PoseStack)matrixStack, (float)this.yangle);
        RenderHelper.rotateZP((PoseStack)matrixStack, (float)this.zangle);
        matrixStack.scale(-this.scale, this.scale, this.scale);
        RenderSystem.disableBlend();
        RenderSystem.disableCull();
        Tesselator tessellator = Tesselator.getInstance();
        GL11.glEnable((int)3089);
        this.renderFacesForGui(tessellator, stack, showScan, false, -1);
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        this.renderHelpers(tessellator, dimension.getX(), dimension.getY(), dimension.getZ(), showAxis, showOuter);
        GL11.glDisable((int)3089);
        matrixStack.popPose();
        if (showGuidelines) {
            RenderSystem.lineWidth((float)3.0f);
            BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex((float)(x - 62), (float)(y + 180), 0.0f).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            buffer.addVertex((float)(x - 39), (float)(y + 180), 0.0f).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            buffer.addVertex((float)(x - 62), (float)(y + 195), 0.0f).setColor(0.0f, 0.8f, 0.0f, 1.0f);
            buffer.addVertex((float)(x - 39), (float)(y + 195), 0.0f).setColor(0.0f, 0.8f, 0.0f, 1.0f);
            buffer.addVertex((float)(x - 62), (float)(y + 210), 0.0f).setColor(0.0f, 0.0f, 1.0f, 1.0f);
            buffer.addVertex((float)(x - 39), (float)(y + 210), 0.0f).setColor(0.0f, 0.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null && !data.previewMessage.isEmpty()) {
            graphics.drawString(Minecraft.getInstance().font, data.previewMessage, gui.getPreviewLeft() + 84, gui.getPreviewTop() + 50, -65536, false);
        }
    }

    private void renderHelpers(Tesselator tessellator, int xlen, int ylen, int zlen, boolean showAxis, boolean showOuter) {
        if (showAxis) {
            ShapeRenderer.renderAxis(tessellator, xlen / 2, ylen / 2, zlen / 2);
        }
        if (showOuter) {
            ShapeRenderer.renderOuterBox(tessellator, xlen, ylen, zlen);
        }
    }

    private void renderHelpersInGui(Tesselator tessellator, int xlen, int ylen, int zlen, boolean showAxis, boolean showOuter) {
        if (showAxis) {
            ShapeRenderer.renderAxisInGui(tessellator, xlen / 2, ylen / 2, zlen / 2);
        }
        if (showOuter) {
            ShapeRenderer.renderOuterBoxInGui(tessellator, xlen, ylen, zlen);
        }
    }

    private static Vec3 setOffset(double x, double y, double z) {
        Vec3 old = offset;
        offset = new Vec3(x, y, z);
        return old;
    }

    private static void restoreOffset(Vec3 prev) {
        offset = prev;
    }

    private static void add(BufferBuilder buffer, double x, double y, double z) {
        buffer.addVertex((float)(x + ShapeRenderer.offset.x), (float)(y + ShapeRenderer.offset.y), (float)(z + ShapeRenderer.offset.z)).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void add(BufferBuilder buffer, double x, double y, double z, float r, float g, float b, float a) {
        buffer.addVertex((float)(x + ShapeRenderer.offset.x), (float)(y + ShapeRenderer.offset.y), (float)(z + ShapeRenderer.offset.z)).setColor(r, g, b, a);
    }

    static void renderOuterBox(Tesselator tessellator, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)1.0f);
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        Vec3 origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        int xleft = -xlen / 2;
        int xright = xlen / 2 + (xlen & 1);
        int ybot = -ylen / 2;
        int ytop = ylen / 2 + (ylen & 1);
        int zsouth = -zlen / 2;
        int znorth = zlen / 2 + (zlen & 1);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.restoreOffset(origOffset);
    }

    static void renderOuterBoxInGui(Tesselator tessellator, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)1.0f);
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        Vec3 origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        int xleft = -xlen / 2;
        int xright = xlen / 2 + (xlen & 1);
        int ybot = -ylen / 2;
        int ytop = ylen / 2 + (ylen & 1);
        int zsouth = -zlen / 2;
        int znorth = zlen / 2 + (zlen & 1);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.restoreOffset(origOffset);
    }

    static void renderAxisInGui(Tesselator tessellator, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)2.5f);
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        Vec3 origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, xlen, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, ylen, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, zlen, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.restoreOffset(origOffset);
    }

    static void renderAxis(Tesselator tessellator, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)2.5f);
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        Vec3 origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, xlen, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, ylen, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, zlen, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.restoreOffset(origOffset);
    }

    private int calculateChecksum(ItemStack stack) {
        Check32 crc = new Check32();
        if (!stack.isEmpty()) {
            ShapeCardItem.getFormulaCheckClient(stack, crc);
        }
        return crc.get();
    }

    private boolean renderFacesInWorld(Tesselator tesselator, ItemStack stack, boolean showScan, boolean grayscale, int scanId) {
        int recursiveScanId;
        RenderData data = ShapeRenderer.getRenderDataAndCreate(this.shapeID);
        if (data.isWantData() || this.waitForNewRequest > 0) {
            if (this.waitForNewRequest <= 0) {
                RFToolsBuilderMessages.sendToServer(PacketRequestShapeData.create(stack, this.shapeID));
                this.waitForNewRequest = 20;
                data.setWantData(false);
            } else {
                --this.waitForNewRequest;
            }
        } else {
            long check = this.calculateChecksum(stack);
            if (!data.hasData() || check != data.getChecksum()) {
                data.setChecksum(check);
                data.setWantData(true);
            }
        }
        boolean needScanSound = false;
        if (data.getPlanes() != null) {
            long time = System.currentTimeMillis();
            for (RenderData.RenderPlane plane : data.getPlanes()) {
                boolean flash;
                if (plane == null) continue;
                if (plane.isDirty()) {
                    this.createRenderData(plane, data, grayscale);
                    plane.markClean();
                }
                boolean bl = flash = showScan && plane.getBirthtime() > time - (long)((Integer)ScannerConfiguration.projectorFlashTimeout.get()).intValue();
                if (flash) {
                    needScanSound = true;
                    GlStateManager._enableBlend();
                    GlStateManager._blendFunc((int)1, (int)1);
                }
                plane.render();
                if (!flash) continue;
                GlStateManager._disableBlend();
                GlStateManager._blendFunc((int)770, (int)771);
            }
        }
        if ((recursiveScanId = ShapeCardItem.getScanIdRecursive(stack)) > 0) {
            --this.extraDataCounter;
            if (this.extraDataCounter <= 0) {
                this.extraDataCounter = 10;
                ScanDataManagerClient.getScansClient().requestExtraDataClient(recursiveScanId);
            }
            ScanExtraData extraData = ScanDataManagerClient.getScansClient().getExtraDataClient(recursiveScanId);
            for (ScanExtraData.Beacon beacon : extraData.getBeacons()) {
                int x = beacon.getPos().getX();
                int y = beacon.getPos().getY() + 1;
                int z = beacon.getPos().getZ();
                BeaconType type = beacon.getType();
                RenderData.RenderElement element = ShapeRenderer.getBeaconElement(tesselator, type, beacon.isDoBeacon());
                element.render();
            }
        }
        return needScanSound;
    }

    private boolean renderFacesForGui(Tesselator tessellator, ItemStack stack, boolean showScan, boolean grayscale, int scanId) {
        int recursiveScanId;
        RenderData data = ShapeRenderer.getRenderDataAndCreate(this.shapeID);
        if (data.isWantData() || this.waitForNewRequest > 0) {
            if (this.waitForNewRequest <= 0) {
                RFToolsBuilderMessages.sendToServer(PacketRequestShapeData.create(stack, this.shapeID));
                this.waitForNewRequest = 20;
                data.setWantData(false);
            } else {
                --this.waitForNewRequest;
            }
        } else {
            long check = this.calculateChecksum(stack);
            if (!data.hasData() || check != data.getChecksum()) {
                data.setChecksum(check);
                data.setWantData(true);
            }
        }
        boolean needScanSound = false;
        if (data.getPlanes() != null) {
            long time = System.currentTimeMillis();
            for (RenderData.RenderPlane plane : data.getPlanes()) {
                boolean flash;
                if (plane == null) continue;
                if (plane.isDirty()) {
                    this.createRenderData(plane, data, grayscale);
                    plane.markClean();
                }
                boolean bl = flash = showScan && plane.getBirthtime() > time - (long)((Integer)ScannerConfiguration.projectorFlashTimeout.get()).intValue();
                if (flash) {
                    needScanSound = true;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)1, (int)1);
                }
                plane.render();
                if (!flash) continue;
                RenderSystem.disableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            }
        }
        if ((recursiveScanId = ShapeCardItem.getScanIdRecursive(stack)) > 0) {
            --this.extraDataCounter;
            if (this.extraDataCounter <= 0) {
                this.extraDataCounter = 10;
                ScanDataManagerClient.getScansClient().requestExtraDataClient(recursiveScanId);
            }
            ScanExtraData extraData = ScanDataManagerClient.getScansClient().getExtraDataClient(recursiveScanId);
            for (ScanExtraData.Beacon beacon : extraData.getBeacons()) {
                int x = beacon.getPos().getX();
                int y = beacon.getPos().getY() + 1;
                int z = beacon.getPos().getZ();
                BeaconType type = beacon.getType();
                RenderData.RenderElement element = ShapeRenderer.getBeaconElement(tessellator, type, beacon.isDoBeacon());
                element.render();
            }
        }
        return needScanSound;
    }

    private void createRenderData(RenderData.RenderPlane plane, RenderData data, boolean grayscale) {
        HashMap<BlockState, ShapeBlockInfo> palette = new HashMap<BlockState, ShapeBlockInfo>();
        int avgcnt = 0;
        int total = 0;
        int y = plane.getY();
        int offsety = plane.getOffsety();
        data.createRenderList(offsety);
        for (RenderData.RenderStrip strip : plane.getStrips()) {
            int z = plane.getStartz();
            int x = strip.getX();
            List<Pair<Integer, BlockState>> columnData = strip.getData();
            for (int i = 0; i < columnData.size(); ++i) {
                Pair<Integer, BlockState> pair = columnData.get(i);
                int cnt = (Integer)pair.getKey();
                BlockState state = (BlockState)pair.getValue();
                if (state != null) {
                    ShapeBlockInfo.IBlockRender bd;
                    Vec3 origOffset = ShapeRenderer.setOffset(x, y, z);
                    avgcnt += cnt;
                    ++total;
                    ShapeBlockInfo info = ShapeBlockInfo.getBlockInfo(palette, state);
                    ShapeBlockInfo.Col col = info.getCol();
                    float r = col.getR();
                    float g = col.getG();
                    float b = col.getB();
                    if (grayscale) {
                        float a;
                        g = b = (a = 0.21f * r + 0.72f * g + 0.07f * b);
                        r = b;
                    }
                    if ((bd = info.getRender()) == null) {
                        ShapeRenderer.addSideFullTextureU(RenderData.vboBuffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        ShapeRenderer.addSideFullTextureD(RenderData.vboBuffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        if (strip.isEmptyAt(i - 1, palette)) {
                            ShapeRenderer.addSideFullTextureN(RenderData.vboBuffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        if (strip.isEmptyAt(i + 1, palette)) {
                            ShapeRenderer.addSideFullTextureS(RenderData.vboBuffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        ShapeRenderer.addSideFullTextureW(RenderData.vboBuffer, cnt, r, g, b);
                        ShapeRenderer.addSideFullTextureE(RenderData.vboBuffer, cnt, r, g, b);
                    } else {
                        for (int c = 0; c < cnt; ++c) {
                            bd.render(RenderData.vboBuffer, c, r, g, b);
                        }
                    }
                    ShapeRenderer.restoreOffset(origOffset);
                }
                z += cnt;
            }
        }
        data.performRenderToList(offsety);
    }

    private static RenderData.RenderElement getBeaconElement(Tesselator tesselator, BeaconType type, boolean doBeacon) {
        RenderData.RenderElement[] elements;
        if (beaconElement == null) {
            beaconElement = new RenderData.RenderElement[BeaconType.VALUES.length];
            beaconElementBeacon = new RenderData.RenderElement[BeaconType.VALUES.length];
            for (int i = 0; i < BeaconType.VALUES.length; ++i) {
                ShapeRenderer.beaconElement[i] = null;
                ShapeRenderer.beaconElementBeacon[i] = null;
            }
        }
        if ((elements = doBeacon ? beaconElementBeacon : beaconElement)[type.ordinal()] == null) {
            elements[type.ordinal()] = new RenderData.RenderElement();
            elements[type.ordinal()].createRenderList();
            RenderSystem.lineWidth((float)3.0f);
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            float r = type.getR();
            float g = type.getG();
            float b = type.getB();
            Vec3 origOffset = ShapeRenderer.setOffset(0.0, -0.7f, 0.0);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.3f);
            ShapeRenderer.restoreOffset(origOffset);
            origOffset = ShapeRenderer.setOffset(0.0, -0.2f, 0.0);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.2f);
            ShapeRenderer.restoreOffset(origOffset);
            if (doBeacon) {
                origOffset = ShapeRenderer.setOffset(0.0, 0.2f, 0.0);
                ShapeRenderer.addSideN(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideS(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideW(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideE(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.restoreOffset(origOffset);
            }
            elements[type.ordinal()].performRenderToList();
        }
        return elements[type.ordinal()];
    }

    private static void setupScissor(IShapeParentGui gui) {
        Minecraft mc = Minecraft.getInstance();
        int xScale = mc.getWindow().getGuiScaledWidth();
        int yScale = mc.getWindow().getGuiScaledHeight();
        int sx = (gui.getPreviewLeft() + 84) * mc.getWindow().getScreenWidth() / xScale;
        int sy = mc.getWindow().getScreenHeight() - (gui.getPreviewTop() + 136) * mc.getWindow().getScreenHeight() / yScale;
        int sw = 161 * mc.getWindow().getScreenWidth() / xScale;
        int sh = 130 * mc.getWindow().getScreenHeight() / yScale;
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    public static void addSideFullTextureD(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
    }

    public static void addSideFullTextureU(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(0.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
    }

    public static void addSideFullTextureE(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
    }

    public static void addSideFullTextureW(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(0.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
    }

    public static void addSideFullTextureN(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
    }

    public static void addSideFullTextureS(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.addVertex(1.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(1.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 1.0f, (float)cnt).setColor(r, g, b, a);
        buffer.addVertex(0.0f, 0.0f, (float)cnt).setColor(r, g, b, a);
    }

    public static void addSideD(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(l, l, l).setColor(r, g, b, a);
        buffer.addVertex(h, l, l).setColor(r, g, b, a);
        buffer.addVertex(h, l, h).setColor(r, g, b, a);
        buffer.addVertex(l, l, h).setColor(r, g, b, a);
    }

    public static void addSideU(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(l, h, h).setColor(r, g, b, a);
        buffer.addVertex(h, h, h).setColor(r, g, b, a);
        buffer.addVertex(h, h, l).setColor(r, g, b, a);
        buffer.addVertex(l, h, l).setColor(r, g, b, a);
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, l, l).setColor(r, g, b, a);
        buffer.addVertex(h, h, l).setColor(r, g, b, a);
        buffer.addVertex(h, h, h).setColor(r, g, b, a);
        buffer.addVertex(h, l, h).setColor(r, g, b, a);
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(l, l, h).setColor(r, g, b, a);
        buffer.addVertex(l, h, h).setColor(r, g, b, a);
        buffer.addVertex(l, h, l).setColor(r, g, b, a);
        buffer.addVertex(l, l, l).setColor(r, g, b, a);
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, h, l).setColor(r, g, b, a);
        buffer.addVertex(h, l, l).setColor(r, g, b, a);
        buffer.addVertex(l, l, l).setColor(r, g, b, a);
        buffer.addVertex(l, h, l).setColor(r, g, b, a);
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, l, h).setColor(r, g, b, a);
        buffer.addVertex(h, h, h).setColor(r, g, b, a);
        buffer.addVertex(l, h, h).setColor(r, g, b, a);
        buffer.addVertex(l, l, h).setColor(r, g, b, a);
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, 0.0f, l).setColor(r, g, b, a);
        buffer.addVertex(h, height, l).setColor(r, g, b, a);
        buffer.addVertex(h, height, h).setColor(r, g, b, a);
        buffer.addVertex(h, 0.0f, h).setColor(r, g, b, a);
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(l, 0.0f, h).setColor(r, g, b, a);
        buffer.addVertex(l, height, h).setColor(r, g, b, a);
        buffer.addVertex(l, height, l).setColor(r, g, b, a);
        buffer.addVertex(l, 0.0f, l).setColor(r, g, b, a);
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, height, l).setColor(r, g, b, a);
        buffer.addVertex(h, 0.0f, l).setColor(r, g, b, a);
        buffer.addVertex(l, 0.0f, l).setColor(r, g, b, a);
        buffer.addVertex(l, height, l).setColor(r, g, b, a);
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.addVertex(h, 0.0f, h).setColor(r, g, b, a);
        buffer.addVertex(h, height, h).setColor(r, g, b, a);
        buffer.addVertex(l, height, h).setColor(r, g, b, a);
        buffer.addVertex(l, 0.0f, h).setColor(r, g, b, a);
    }
}

