/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.config;

import com.cupboard.config.ICommonConfig;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CommonConfiguration
implements ICommonConfig {
    public Set<String> respawnableStructureIDs = new LinkedHashSet<String>(Lists.newArrayList());
    public boolean whitelist = false;
    public Set<String> blacklistedStructures = new LinkedHashSet<String>();
    public Set<String> dimensionBlackList = new LinkedHashSet<String>();
    public int minutesUntilRespawn = 5760;
    public double blockCountMod = 1.0;
    public boolean enableAutomaticRespawn = true;
    public boolean increaseDifficultyWithRespawn = true;
    public int playerRespawnDist = 200;
    public int playerNearbyTime = 15;
    public boolean logRespawns = true;
    public boolean needReload = true;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Enables automatic respawning of structures, default:true");
        entry.addProperty("enableAutomaticRespawn", Boolean.valueOf(this.enableAutomaticRespawn));
        root.add("enableAutomaticRespawn", (JsonElement)entry);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Sets the time after which a structure can respawn, the timer starts after the last activity within the structure. default:5760 minutes(96h)");
        entry7.addProperty("minutesUntilRespawn", (Number)this.minutesUntilRespawn);
        root.add("minutesUntilRespawn", (JsonElement)entry7);
        JsonObject entry11 = new JsonObject();
        entry11.addProperty("desc:", "Enables increased difficulty for mobs in respawned dungeons(mobs can get enchanted items/potions effects), default: true");
        entry11.addProperty("increaseDifficultyWithRespawn", Boolean.valueOf(this.increaseDifficultyWithRespawn));
        root.add("increaseDifficultyWithRespawn", (JsonElement)entry11);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Modifies the placed/broken block count, which can prevent respawn. Setting it to zero means respawn will ignore placed/broken blocks. Setting it higher than 1.0 makes it more likely that players breaking/placing things in the structure will prevent its respawn.By default it blocks respawn after 200+(scales slightly with structure size) blocks placed/broken. default: 1.0");
        entry8.addProperty("blockCountMod", (Number)this.blockCountMod);
        root.add("blockCountMod", (JsonElement)entry8);
        JsonObject entry17 = new JsonObject();
        entry17.addProperty("desc:", "Sets the minimum distance from player respawn position(bed e.g.) to allow structure respawning, 0 to disable this. default: 200 blocks");
        entry17.addProperty("playerRespawnDist", (Number)this.playerRespawnDist);
        root.add("playerRespawnDist", (JsonElement)entry17);
        JsonObject entry18 = new JsonObject();
        entry18.addProperty("desc:", "Prevents respawns in too busy player areas, tracks how much percent of the respawntime a player was nearby loading the chunk. Resets respawn time counter when it prevent a structure respawn. default: 15 percent, range 0-100");
        entry18.addProperty("playerNearbyTime", (Number)this.playerNearbyTime);
        root.add("playerNearbyTime", (JsonElement)entry18);
        JsonObject entry10 = new JsonObject();
        entry10.addProperty("desc:", "List of blacklisted dimension ids, e.g. minecraft:overworld  Seperate multiple entries by , ");
        JsonArray list10 = new JsonArray();
        for (String name : this.dimensionBlackList) {
            list10.add(name);
        }
        entry10.add("dimensionBlackList", (JsonElement)list10);
        root.add("dimensionBlackList", (JsonElement)entry10);
        JsonObject entry12 = new JsonObject();
        entry12.addProperty("desc:", "List of structure IDs(or tags of structures) that should respawn always respawn, no matter if a player build sth inside, has a portal there etc.: e.g. minecraft:mansion");
        JsonArray list8 = new JsonArray();
        for (String name : this.respawnableStructureIDs) {
            list8.add(name);
        }
        entry12.add("respawnableStructures", (JsonElement)list8);
        root.add("respawnableStructures", (JsonElement)entry12);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "List of blacklisted structures(or tags of structures), those won't respawn ever: e.g. minecraft:mansion   Seperate multiple entries by , ");
        JsonArray list6 = new JsonArray();
        for (String name : this.blacklistedStructures) {
            list6.add(name);
        }
        entry6.add("blacklistedStructures", (JsonElement)list6);
        root.add("blacklistedStructures", (JsonElement)entry6);
        JsonObject entry14 = new JsonObject();
        entry14.addProperty("desc:", "Changes the structure blacklist to a whitelist, default: false");
        entry14.addProperty("whitelist", Boolean.valueOf(this.whitelist));
        root.add("whitelist", (JsonElement)entry14);
        JsonObject entry19 = new JsonObject();
        entry19.addProperty("desc:", "Log structure respawns happening to the latest.log, default: true");
        entry19.addProperty("logRespawns", Boolean.valueOf(this.logRespawns));
        root.add("logRespawns", (JsonElement)entry19);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.needReload = true;
        this.minutesUntilRespawn = data.get("minutesUntilRespawn").getAsJsonObject().get("minutesUntilRespawn").getAsInt();
        this.playerRespawnDist = data.get("playerRespawnDist").getAsJsonObject().get("playerRespawnDist").getAsInt();
        this.playerNearbyTime = data.get("playerNearbyTime").getAsJsonObject().get("playerNearbyTime").getAsInt();
        this.enableAutomaticRespawn = data.get("enableAutomaticRespawn").getAsJsonObject().get("enableAutomaticRespawn").getAsBoolean();
        this.logRespawns = data.get("logRespawns").getAsJsonObject().get("logRespawns").getAsBoolean();
        this.whitelist = data.get("whitelist").getAsJsonObject().get("whitelist").getAsBoolean();
        this.increaseDifficultyWithRespawn = data.get("increaseDifficultyWithRespawn").getAsJsonObject().get("increaseDifficultyWithRespawn").getAsBoolean();
        this.blockCountMod = data.get("blockCountMod").getAsJsonObject().get("blockCountMod").getAsDouble();
        this.blacklistedStructures = new HashSet<String>();
        for (JsonElement element : data.get("blacklistedStructures").getAsJsonObject().get("blacklistedStructures").getAsJsonArray()) {
            this.blacklistedStructures.add(element.getAsString());
        }
        this.dimensionBlackList = new HashSet<String>();
        for (JsonElement element : data.get("dimensionBlackList").getAsJsonObject().get("dimensionBlackList").getAsJsonArray()) {
            this.dimensionBlackList.add(element.getAsString());
        }
        this.respawnableStructureIDs = new HashSet<String>();
        for (JsonElement element : data.get("respawnableStructures").getAsJsonObject().get("respawnableStructures").getAsJsonArray()) {
            this.respawnableStructureIDs.add(element.getAsString());
        }
    }
}

