/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.items.relics.head;

import it.hurts.octostudios.reliquified_lenders_cataclysm.entities.VoidShardModifiedEntity;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.ItemRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.RECDataComponentRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.RECItem;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.ItemUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.RECMathUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class VoidBubbleItem
extends RECItem {
    private static final String ABILITY_ID = "protective_bubble";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)ABILITY_ID).stat(StatData.builder((String)"attack_blocks").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(RECMathUtils::roundInt).build()).stat(StatData.builder((String)"projectiles").initialValue(16.0, 20.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.22).formatValue(RECMathUtils::roundInt).build()).stat(StatData.builder((String)"damage").initialValue(0.4, 0.6).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.56).formatValue(RECMathUtils::roundDamage).build()).stat(StatData.builder((String)"cooldown").initialValue(30.0, 25.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.068).formatValue(RECMathUtils::roundOneDigit).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).step(100).maxLevel(10).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)ABILITY_ID).gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.THE_END}).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-24639).borderBottom(-1615477).textured(true).build()).beams(BeamsData.builder().startColor(-2791990).endColor(4849829).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity;
        block7: {
            block6: {
                livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                livingEntity = stack.getItem();
                if (livingEntity instanceof VoidBubbleItem) break block7;
            }
            return;
        }
        VoidBubbleItem relic = (VoidBubbleItem)livingEntity;
        Level level = player.getCommandSenderWorld();
        if (level.isClientSide) {
            return;
        }
        if (VoidBubbleItem.getAttackBlocks(stack) == this.getAttackBlocksStat(stack)) {
            VoidBubbleItem.setCooldown((IRelicItem)relic, stack);
            stack.set(RECDataComponentRegistry.ATTACK_BLOCKS, (Object)0);
        }
        if (this.getAbilityCooldown(stack, ABILITY_ID) == 1) {
            ItemUtils.playCooldownSound(level, (LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerBreathe(LivingBreatheEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.VOID_BUBBLE.get()));
        if (stack.isEmpty() || !(stack.getItem() instanceof VoidBubbleItem)) {
            return;
        }
        event.setCanBreathe(true);
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingIncomingDamageEvent event) {
        int attackBlocksStat;
        VoidBubbleItem relic;
        Item item;
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (event.getSource().getEntity() instanceof Entity) break block7;
            }
            return;
        }
        Level level = player.getCommandSenderWorld();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.VOID_BUBBLE.get()));
        if (level.isClientSide || stack.isEmpty() || !((item = stack.getItem()) instanceof VoidBubbleItem) || (relic = (VoidBubbleItem)item).isAbilityOnCooldown(stack, ABILITY_ID)) {
            return;
        }
        int attackBlocks = VoidBubbleItem.getAttackBlocks(stack);
        if (attackBlocks < (attackBlocksStat = relic.getAttackBlocksStat(stack))) {
            if (attackBlocks == attackBlocksStat - 1) {
                relic.spawnShards((LivingEntity)player, stack);
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            level.playSound(null, player.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS);
            event.setCanceled(true);
            stack.set(RECDataComponentRegistry.ATTACK_BLOCKS, (Object)(attackBlocks + 1));
        }
    }

    private void spawnShards(LivingEntity caster, ItemStack stack) {
        Level level = caster.getCommandSenderWorld();
        int projectilesNum = ItemUtils.getIntStat(stack, ABILITY_ID, "projectiles");
        List<Vec3> movementVecs = this.getShootVectors(caster.getRandom(), projectilesNum);
        for (int i = 0; i < projectilesNum; ++i) {
            Vec3 movementVec = movementVecs.get(i).scale(0.35);
            VoidShardModifiedEntity shardEntity = new VoidShardModifiedEntity(level, caster, caster.getX() + movementVec.x, caster.getY() + movementVec.y + 1.2, caster.getZ() + movementVec.z, movementVec, (Entity)caster, this.getDamageStat(stack));
            level.addFreshEntity((Entity)shardEntity);
        }
        level.playSound(null, caster.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL);
    }

    public List<Vec3> getShootVectors(RandomSource random, float projectilesNum) {
        ArrayList<Vec3> vectors = new ArrayList<Vec3>();
        float turnFraction = (1.0f + Mth.sqrt((float)5.0f)) / 2.0f;
        int i = 1;
        while ((float)i <= projectilesNum) {
            float progress = (float)i / projectilesNum;
            float inclination = (float)Math.acos(1.0f - 2.0f * progress);
            float azimuth = (float)((double)(turnFraction * (float)i + random.nextFloat()) * Math.PI * 2.0);
            double x = Math.sin(inclination) * Math.cos(azimuth);
            double y = Math.cos(inclination);
            double z = Math.sin(inclination) * Math.sin(azimuth);
            Vec3 vec = new Vec3(x, y, z);
            if (i == 1) {
                vec = vec.add(0.0, 1.0, 0.0).scale(0.5);
            }
            vectors.add(vec);
            ++i;
        }
        return vectors;
    }

    private static int getAttackBlocks(ItemStack stack) {
        return (Integer)stack.getOrDefault(RECDataComponentRegistry.ATTACK_BLOCKS, (Object)0);
    }

    private int getAttackBlocksStat(ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, ABILITY_ID, "attack_blocks"));
    }

    private float getDamageStat(ItemStack stack) {
        return (float)this.getStatValue(stack, ABILITY_ID, "damage");
    }

    private static void setCooldown(IRelicItem relic, ItemStack stack) {
        relic.setAbilityCooldown(stack, ABILITY_ID, ItemUtils.getCooldownStat(stack, ABILITY_ID));
    }
}

