/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import it.hurts.octostudios.reliquified_ars_nouveau.entities.WhirlingBroomEntity;
import it.hurts.octostudios.reliquified_ars_nouveau.init.EntityRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.network.packets.ActivatedBoostBroomPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CEntityMotionPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import top.theillusivec4.curios.api.SlotContext;

public class WhirlingBroomItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"broom").active(CastData.builder().type(CastType.INSTANTANEOUS).predicate("broom", PredicateType.CAST, (player, stack) -> !player.isInLiquid()).build()).stat(StatData.builder((String)"height").initialValue(15.0, 20.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"manacost").initialValue(70.0, 60.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.025).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"boost").initialValue(0.8, 1.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.173).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"health").initialValue(10.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.215).formatValue(value -> (int)MathUtils.round((double)(value + 2.0), (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"broom").initialValue(1).gem(GemShape.SQUARE, GemColor.GREEN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-7347935).endColor(1135403).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.getCommandSenderWorld().isClientSide()) {
            return;
        }
        if (player.getVehicle() instanceof WhirlingBroomEntity) {
            player.stopRiding();
        } else {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            WhirlingBroomEntity broom = new WhirlingBroomEntity((EntityType<? extends Mob>)((EntityType)EntityRegistry.WHIRLING_BROOM.get()), (Level)level);
            broom.setPos(player.getPosition(1.0f));
            broom.setNoGravity(true);
            broom.setYRot(player.getYRot());
            broom.setXRot(player.getXRot());
            broom.yBodyRot = broom.yHeadRot = broom.getYRot();
            broom.yRotO = broom.yHeadRot;
            level.addFreshEntity((Entity)broom);
            EntityUtils.applyAttribute((LivingEntity)broom, (ItemStack)ItemStack.EMPTY, (Holder)Attributes.MAX_HEALTH, (float)((float)MathUtils.round((double)this.getStatValue(stack, "broom", "health"), (int)0)), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
            broom.setHealth(broom.getMaxHealth());
            if (this.getHealth(stack) > 0.0f) {
                broom.setHealth(this.getHealth(stack));
                this.setHealth(stack, 0.0f);
            }
            player.startRiding((Entity)broom);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LocalPlayer player;
        LivingEntity livingEntity;
        if (!(slotContext.entity().getCommandSenderWorld().isClientSide() && (livingEntity = slotContext.entity()) instanceof LocalPlayer && (livingEntity = (player = (LocalPlayer)livingEntity).getVehicle()) instanceof WhirlingBroomEntity)) {
            return;
        }
        WhirlingBroomEntity broom = (WhirlingBroomEntity)livingEntity;
        NetworkHandler.sendToServer((CustomPacketPayload)new ActivatedBoostBroomPacket(Minecraft.getInstance().options.keySprint.isDown()));
        double speed = 1.7;
        if (this.getToggled(stack)) {
            speed += speed * MathUtils.round((double)this.getStatValue(stack, "broom", "boost"), (int)0);
        }
        double turnRate = 0.1;
        Vec3 movement = Vec3.ZERO;
        Vec3 lookDir = Vec3.directionFromRotation((float)player.getXRot(), (float)player.getYRot());
        if (player.zza != 0.0f) {
            movement = movement.add(lookDir.scale((double)player.zza * speed * (player.zza < 0.0f ? 0.5 : 1.0)));
        }
        if (player.xxa != 0.0f) {
            movement = movement.add(new Vec3(lookDir.z, 0.0, -lookDir.x).normalize().scale((double)player.xxa * speed * 0.5));
        }
        Vec3 start = broom.position();
        BlockHitResult hitResult = broom.getCommandSenderWorld().clip(new ClipContext(start, start.add(0.0, -MathUtils.round((double)this.getStatValue(stack, "broom", "height"), (int)0), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)broom));
        if (hitResult.getType() == HitResult.Type.MISS) {
            movement = new Vec3(movement.x(), -0.8, movement.z());
        }
        if (!movement.equals((Object)Vec3.ZERO)) {
            broom.setDeltaMovement(broom.getDeltaMovement().lerp(movement, turnRate));
        }
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
    }

    public float getHealth(ItemStack stack) {
        return ((Float)stack.getOrDefault(RANDataComponentRegistry.HEALTH, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setHealth(ItemStack stack, float val) {
        stack.set(RANDataComponentRegistry.HEALTH, (Object)Float.valueOf(Math.max(val, 0.0f)));
    }

    @EventBusSubscriber
    public static class WhirlingBroomEvent {
        @SubscribeEvent
        public static void onPlayerRideEntity(EntityMountEvent event) {
            Player player;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player) || (player = (Player)entity).getCommandSenderWorld().isClientSide() || !((entity = event.getEntityBeingMounted()) instanceof WhirlingBroomEntity)) {
                return;
            }
            WhirlingBroomEntity broom = (WhirlingBroomEntity)entity;
            if (event.isDismounting()) {
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
                Item item = stack.getItem();
                if (!(item instanceof WhirlingBroomItem)) {
                    return;
                }
                WhirlingBroomItem relic = (WhirlingBroomItem)item;
                relic.setHealth(stack, broom.getHealth());
            } else {
                Vec3 broomMotion = player.getDeltaMovement().add(player.getDeltaMovement());
                NetworkHandler.sendToClient((CustomPacketPayload)new S2CEntityMotionPacket(broom.getId(), broomMotion.x, broomMotion.y / 4.0, broomMotion.z), (ServerPlayer)((ServerPlayer)player));
            }
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class WhirlingBroomClientEvent {
        private static float currentFovModifier = 0.0f;

        @SubscribeEvent
        public static void onComputeFov(ComputeFovModifierEvent event) {
            WhirlingBroomItem relic;
            Item item;
            ItemStack stack;
            block3: {
                block2: {
                    Player player = event.getPlayer();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
                    item = stack.getItem();
                    if (!(item instanceof WhirlingBroomItem)) break block2;
                    relic = (WhirlingBroomItem)item;
                    item = player.getVehicle();
                    if (item instanceof WhirlingBroomEntity) break block3;
                }
                return;
            }
            WhirlingBroomEntity broom = (WhirlingBroomEntity)item;
            currentFovModifier = !relic.getToggled(stack) || broom.getKnownMovement().length() < 0.0785 ? Mth.lerp((float)0.1f, (float)currentFovModifier, (float)0.0f) : Mth.lerp((float)0.1f, (float)currentFovModifier, (float)((float)(relic.getStatValue(stack, "broom", "boost") / 10.0)));
            event.setNewFovModifier(event.getFovModifier() + currentFovModifier);
        }
    }
}

