/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitor;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorData;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorWatcher;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;

public class AutocraftingMonitorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<AutocraftingMonitorData>,
AutocraftingMonitor {
    private final Set<AutocraftingMonitorWatcher> watchers = new HashSet<AutocraftingMonitorWatcher>();

    public AutocraftingMonitorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getAutocraftingMonitor(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getAutocraftingMonitor().getEnergyUsage()));
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.watchers.forEach(watcher -> watcher.activeChanged(newActive));
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.AUTOCRAFTING_MONITOR);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public AutocraftingMonitorData getMenuData() {
        return new AutocraftingMonitorData(this.getStatuses(), this.isAutocraftingMonitorActive());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, AutocraftingMonitorData> getMenuCodec() {
        return AutocraftingMonitorData.STREAM_CODEC;
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new AutocraftingMonitorContainerMenu(syncId, player, this);
    }

    private Optional<AutocraftingNetworkComponent> getAutocrafting() {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return Optional.empty();
        }
        return Optional.of(network.getComponent(AutocraftingNetworkComponent.class));
    }

    @Override
    public List<TaskStatus> getStatuses() {
        return this.getAutocrafting().map(TaskStatusProvider::getStatuses).orElse(Collections.emptyList());
    }

    @Override
    public void addListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.addListener(listener));
    }

    @Override
    public void removeListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.removeListener(listener));
    }

    @Override
    public void cancel(TaskId taskId) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.cancel(taskId));
    }

    @Override
    public void cancelAll() {
        this.getAutocrafting().ifPresent(TaskStatusProvider::cancelAll);
    }

    @Override
    public void addWatcher(AutocraftingMonitorWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Override
    public void removeWatcher(AutocraftingMonitorWatcher watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    public boolean isAutocraftingMonitorActive() {
        return ((SimpleNetworkNode)this.mainNetworkNode).isActive();
    }
}

