/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PatternItem
extends Item
implements PatternProviderItem {
    private static final Map<UUID, PatternResolver.ResolvedCraftingPattern> CRAFTING_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedCraftingPattern>();
    private static final Map<UUID, PatternResolver.ResolvedProcessingPattern> PROCESSING_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedProcessingPattern>();
    private static final Map<UUID, PatternResolver.ResolvedSmithingTablePattern> SMITHING_TABLE_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedSmithingTablePattern>();
    private static final Map<UUID, PatternResolver.ResolvedStonecutterPattern> STONE_CUTTER_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedStonecutterPattern>();
    private static final Component HELP = IdentifierUtil.createTranslation("item", "pattern.help");
    private static final MutableComponent FUZZY_MODE = IdentifierUtil.createTranslation("item", "pattern.fuzzy_mode").withStyle(ChatFormatting.YELLOW);
    private final PatternResolver resolver = new PatternResolver();

    public PatternItem() {
        super(new Item.Properties());
    }

    public String getDescriptionId(ItemStack stack) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state != null) {
            return IdentifierUtil.createTranslationKey("misc", "pattern." + state.type().getSerializedName());
        }
        return super.getDescriptionId(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, lines, tooltipFlag);
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return;
        }
        CraftingPatternState craftingState = (CraftingPatternState)stack.get(DataComponents.INSTANCE.getCraftingPatternState());
        if (craftingState != null && craftingState.fuzzyMode()) {
            lines.add((Component)FUZZY_MODE);
        }
    }

    public boolean hasMapping(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getPatternState());
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.of(new HelpTooltipComponent(HELP));
        }
        Level level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> {
                CraftingPatternState craftingState = (CraftingPatternState)stack.get(DataComponents.INSTANCE.getCraftingPatternState());
                if (craftingState == null) {
                    yield Optional.empty();
                }
                yield this.getCachedCraftingPattern(state, stack, level).map(pattern -> new CraftingPatternTooltipComponent(state.id(), (PatternResolver.ResolvedCraftingPattern)pattern, craftingState.input().input().width(), craftingState.input().input().height()));
            }
            case PatternType.PROCESSING -> {
                ProcessingPatternState processingState = (ProcessingPatternState)stack.get(DataComponents.INSTANCE.getProcessingPatternState());
                if (processingState == null) {
                    yield Optional.empty();
                }
                yield Optional.of(new ProcessingPatternTooltipComponent(state.id(), processingState));
            }
            case PatternType.STONECUTTER -> this.getCachedStonecutterPattern(state, stack, level).map(pattern -> new StonecutterPatternTooltipComponent(state.id(), (PatternResolver.ResolvedStonecutterPattern)pattern));
            case PatternType.SMITHING_TABLE -> this.getCachedSmithingTablePattern(state, stack, level).map(pattern -> new SmithingTablePatternTooltipComponent(state.id(), (PatternResolver.ResolvedSmithingTablePattern)pattern));
        };
    }

    @Override
    @Nullable
    public UUID getId(ItemStack stack) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return null;
        }
        return state.id();
    }

    @Override
    public Optional<Pattern> getPattern(ItemStack stack, Level level) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> this.resolver.getCraftingPattern(stack, level, state).map(PatternResolver.ResolvedCraftingPattern::pattern);
            case PatternType.PROCESSING -> this.resolver.getProcessingPattern(state, stack).map(PatternResolver.ResolvedProcessingPattern::pattern);
            case PatternType.STONECUTTER -> this.resolver.getStonecutterPattern(stack, level, state).map(PatternResolver.ResolvedStonecutterPattern::pattern);
            case PatternType.SMITHING_TABLE -> this.resolver.getSmithingTablePattern(state, stack, level).map(PatternResolver.ResolvedSmithingTablePattern::pattern);
        };
    }

    @Override
    public Optional<ItemStack> getOutput(ItemStack stack, Level level) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> this.getCachedCraftingPattern(state, stack, level).map(PatternResolver.ResolvedCraftingPattern::output).map(ResourceAmount::resource).filter(ItemResource.class::isInstance).map(ItemResource.class::cast).map(ItemResource::toItemStack);
            case PatternType.PROCESSING -> this.getCachedProcessingPattern(state, stack).map(PatternResolver.ResolvedProcessingPattern::pattern).filter(pattern -> pattern.layout().outputs().size() == 1).map(pattern -> pattern.layout().outputs().getFirst().resource()).filter(ItemResource.class::isInstance).map(ItemResource.class::cast).map(ItemResource::toItemStack);
            case PatternType.STONECUTTER -> this.getCachedStonecutterPattern(state, stack, level).map(PatternResolver.ResolvedStonecutterPattern::output).map(ItemResource::toItemStack);
            case PatternType.SMITHING_TABLE -> this.getCachedSmithingTablePattern(state, stack, level).map(PatternResolver.ResolvedSmithingTablePattern::output).map(ItemResource::toItemStack);
        };
    }

    private Optional<PatternResolver.ResolvedCraftingPattern> getCachedCraftingPattern(PatternState state, ItemStack stack, Level level) {
        PatternResolver.ResolvedCraftingPattern pattern = CRAFTING_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getCraftingPattern(stack, level, state).map(resolved -> {
                CRAFTING_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedCraftingPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedSmithingTablePattern> getCachedSmithingTablePattern(PatternState state, ItemStack stack, Level level) {
        PatternResolver.ResolvedSmithingTablePattern pattern = SMITHING_TABLE_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getSmithingTablePattern(state, stack, level).map(resolved -> {
                SMITHING_TABLE_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedSmithingTablePattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedStonecutterPattern> getCachedStonecutterPattern(PatternState state, ItemStack stack, Level level) {
        PatternResolver.ResolvedStonecutterPattern pattern = STONE_CUTTER_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getStonecutterPattern(stack, level, state).map(resolved -> {
                STONE_CUTTER_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedStonecutterPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedProcessingPattern> getCachedProcessingPattern(PatternState state, ItemStack stack) {
        PatternResolver.ResolvedProcessingPattern pattern = PROCESSING_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getProcessingPattern(state, stack).map(resolved -> {
                PROCESSING_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedProcessingPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && player.isCrouching()) {
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)new ItemStack((ItemLike)Items.INSTANCE.getPattern(), stack.getCount()));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public record ProcessingPatternTooltipComponent(UUID id, ProcessingPatternState state) implements TooltipComponent
    {
    }

    public record SmithingTablePatternTooltipComponent(UUID id, PatternResolver.ResolvedSmithingTablePattern pattern) implements TooltipComponent
    {
    }

    public record StonecutterPatternTooltipComponent(UUID id, PatternResolver.ResolvedStonecutterPattern pattern) implements TooltipComponent
    {
    }

    public record CraftingPatternTooltipComponent(UUID id, PatternResolver.ResolvedCraftingPattern pattern, int width, int height) implements TooltipComponent
    {
    }
}

