/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternInventory
extends FilteredContainer {
    @Nullable
    private Listener listener;

    public PatternInventory(int patterns, Supplier<@NullableType Level> levelSupplier) {
        super(patterns, (ItemStack stack) -> Optional.ofNullable((Level)levelSupplier.get()).map(level -> PatternProviderItem.isValid(stack, level)).orElse(false));
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result = super.removeItem(slot, amount);
        if (this.listener != null) {
            this.listener.patternChanged(slot);
        }
        return result;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        if (this.listener != null) {
            this.listener.patternChanged(slot);
        }
    }

    public long getEnergyUsage() {
        long patterns = 0L;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            ++patterns;
        }
        return patterns * Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsagePerPattern();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public static interface Listener {
        public void patternChanged(int var1);
    }
}

